<?PHP
#
#   FILE:  SPT--SysAdmin.php
#
#   FUNCTIONS PROVIDED:
#       PrintOaiHarvestLink()
#           - print link to OAI harvest info
#       PrintRssFeedLink()
#           - print link to SPT RSS feed    
#       PrintOaiTestLink()
#           - print link to test OAI
#       PrintRssTestLink()
#           - print link to validate RSS feed
#       PrintSupportedFormatNames()
#           - print comma-seperated list of supported image formats
#       PrintLoggedInUsers()
#           - print all users currently logged in to system
#       CountLoggedInUsers()
#           - returns number of currently logged in users
#
#   FUNCTIONS EXPECTED:
#       PrintUserRow( $Username, $LoginTime )
#           - print information for a logged in user
#
#   OPTIONAL FUNCTIONS:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--SPTImage.php");
require_once("Axis--UserFactory.php");

PageTitle("System Administration");


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintOaiHarvestLink()
{
    print(OurBaseUrl()."SPT--OAI.php");
}

function PrintRssFeedLink()
{
    print(OurBaseUrl()."SPT--RSS.php");
}

function PrintOaiTestLink()
{
    $OurUrl = OurBaseUrl()."SPT--OAI.php";
    $Link = "http://re.cs.uct.ac.za/cgi-bin/Explorer/2.0-1.46/testoai?"
            ."metadataPrefix=oai_dc&archive=".$OurUrl;
    print($Link);
}

function PrintRssTestLink()
{
    $OurUrl = OurBaseUrl()."SPT--RSS.php";
    $Link = "http://feedvalidator.org/check?url=".$OurUrl;
    print($Link);
}

function PrintSupportedFormatNames()
{
    $FormatNames = Image::SupportedFormatNames();
    $count = count($FormatNames);
    foreach ( $FormatNames as $Name )
    {
        print $Name;
        if ( --$count != 0 )
            print ", "; 
    }
}


# ----- LOCAL FUNCTIONS ------------------------------------------------------



# ----- MAIN -----------------------------------------------------------------

$UserFactory = new UserFactory($Session);
$G_LoggedInUsers = $UserFactory->GetLoggedInUsers();

# check if current user is authorized
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN, PRIV_USERADMIN);

include("include/SPT--StandardHtmlPageLoad.php");


?>
