<?php
#
#   FILE:  SPT--MetadataHelp3.php
#
#   FUNCTIONS PROVIDED:
#       None.
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# provide relative path to base SPT directory

$NavDirCorrection = "../";
require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");

PageTitle("Metadata Tool - Help - Resource Field Definitions");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintFieldName()
{
    global $FieldName;

    print $FieldName;
}
function PrintDescription()
{
    global $Description;

    print $Description;
}

function PrintFieldDefinitions()
{
    global $FieldName, $Description;
    
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields();
    foreach ($Fields as $Field)
    {
        $FieldName = $Field->Name(); 
        $Description = $Field->Description();
        PrintFieldDefinition();
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_SYSADMIN);

include("include/SPT--StandardHtmlPageLoad.php");
?>

