<?php
#
#   FILE:  SPT--AddRecord.php
#
#   FUNCTIONS PROVIDED:
#
#   FUNCTIONS EXPECTED:
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--ClassificationFactory.php");
require_once("include/SPT--Classification.php");
require_once("include/SPT--SearchEngine.php");
require_once("include/SPT--Recommender.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--SPTDate.php");
require_once("include/SPT--Resource.php");
require_once("include/SPT--ResourceFactory.php");
require_once("include/SPT--ControlledName.php");
require_once("include/SPT--File.php");

# provide relative path to base SPT directory
$NavDirCorrection = "../";

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print DBFieldName
function PrintDBFieldName()
{
    global $Field;

    print $Field->DBFieldName();
}

# print FieldName
function PrintFieldName()
{
    global $Field;

    print $Field->Name();
}

# print Field value
function PrintValue()
{
    global $Value;

    print stripslashes($Value);
}

function PrintQualifier()
{
    global $Field;
    global $Result;
    global $Value;
    global $GenericId;
    global $QualifierId;

    if ($Field->UsesQualifiers())
    {
        $Qualifier = $Result[$Field->Name()." Qualifier"];
        # normal field
        if (is_object($Qualifier))
        {
            $Name = $Qualifier->Name();
            if (!empty($Name))
                print " <small>(<a href=\"".$Qualifier->Url()."\">".
                    $Qualifier->Name()."</a>)</small>";
        }
        # controlled name, options, or classifications, use global Qualifier
        else if (is_array($Qualifier))
        {
            # look up this qualifier
            foreach ($Qualifier as $ArrayId => $QualifierObj)
            {
                if ($ArrayId == $GenericId)
                    break;
            }
            if (is_object($QualifierObj))
            {
                $Name = $QualifierObj->Name();
                if (!empty($Name))
                    print "<small> (<a href=\"".$QualifierObj->Url()."\">".
                        $QualifierObj->Name()."</a>)</small>";
            }
        }
    }
}

# display text fields
function DisplayAllFields()
{
    global $Result;
    global $Field;
    global $Value;
    global $QualifierId;
    global $User;
    global $ResourceId;
    global $SPTImage;

    $Resource = new Resource($ResourceId);

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(NULL, MDFORDER_EDITING);

    foreach ($Fields as $Field)
    {
        if ($Field->Enabled())
        {
            # suppress display of empty fields except for flag fields
            if (!empty($Result[$Field->Name()])
                    || $Field->Type() == MDFTYPE_FLAG)
            {
                $Value = $Result[$Field->Name()];
                switch($Field->Type())
                {
                    case MDFTYPE_NUMBER:
                    case MDFTYPE_TIMESTAMP:
                    case MDFTYPE_TEXT:
                        DisplayTextField();
                        break;

                    case MDFTYPE_PARAGRAPH:
                        DisplayParagraph();
                        break;

                    case MDFTYPE_DATE:
                        $Date = $Value;
                        if (is_object($Date))
                        {
                            $Value = $Date->Formatted();
                            if (!empty($Value))
                                DisplayTextField();
                        }
                        break;

                    case MDFTYPE_FLAG:
                        $Value = $Result[$Field->Name()] ?
                            $Field->FlagOnLabel() : $Field->FlagOffLabel();
                        DisplayFlagField();
                        break;

                    case MDFTYPE_TREE:
                        DisplayClassifications();
                        break;

                    case MDFTYPE_OPTION:
                        DisplayOptions();
                        break;

                    case MDFTYPE_CONTROLLEDNAME:
                        DisplayControlledNames();
                        break;

                    case MDFTYPE_USER:
                        $NewUser = $Value;
                        if (is_object($NewUser))
                        {
                            $Value = $NewUser->Get("UserName");
                            DisplayTextField();
                        }
                        break;

                    case MDFTYPE_IMAGE:
                        if (is_object($Resource))
                        {
                            $SPTImage = $Resource->GetByField($Field, TRUE);
                            if (is_object($SPTImage))
                            {
                                if (is_readable($SPTImage->ThumbnailUrl()))
                                    DisplayImageField($Field->Name(),
                                        $SPTImage->Url(),
                                        $SPTImage->ThumbnailUrl(),
                                        $SPTImage->AltText());
                            }
                        }
                        break;

                    case MDFTYPE_FILE:
                        if ($Resource->UserCanViewField($User, $Field))
                        {
                            DisplayFileField($Field, $Resource);
                        }
                        break;
                }
            }
        }
    }
}

# print Url
function PrintUrl()
{
    global $SPTImage;

    print $SPTImage->Url();
}

# print ThumbnailUrl
function PrintThumbnailUrl()
{
    global $SPTImage;

    print $SPTImage->ThumbnailUrl();
}

# print ThumbnailUrl
function PrintAltText()
{
    global $SPTImage;

    print $SPTImage->AltText();
}

# display controlled names and buttons
function DisplayImageFields()
{
    global $ResourceId;
    global $Field;
    global $SPTImage;

    # Get the schema
    $Schema = new MetadataSchema();
    $DB = new SPTDatabase();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_IMAGE);

    foreach ($Fields as $Field)
    {
        if ($Field->Enabled())
        {
            if ($ResourceId)
            {
                $Resource = new Resource($ResourceId);
                $SPTImage = $Resource->GetByField($Field, TRUE);

                if (is_object($SPTImage))
                {
                    if (is_readable($SPTImage->ThumbnailUrl()))
                        DisplayImageField($Field->Name(),
                            $SPTImage->Url(),
                            $SPTImage->ThumbnailUrl(),
                            $SPTImage->AltText());
                }
            }
        }
    }
}

#  list out all Options associated with a Resource
function DisplayOptions()
{
    global $Resource, $Field, $Value, $GenericId;

    $Schema = new MetadataSchema();
    $Options = $Resource->Get($Field->Name());
    if (is_array($Options))
    {
        foreach ($Options as $GenericId => $Value)
        {
            # ignore empty options and NULL values
            if (isset($Value))
            {
                DisplayTextField();
            }
        }
    }
}

#  list out all ControlledNames associated with a Resource
function DisplayControlledNames()
{
    global $Resource, $Field, $Value, $GenericId;

    $Schema = new MetadataSchema();
    $ControlledNames = $Resource->Get($Field->Name());
    if (is_array($ControlledNames))
    {
        foreach ($ControlledNames as $GenericId => $Value)
        {
            # ignore empty authors and NULL values
            if (isset($Value))
            {
                DisplayTextField();
            }
        }
    }
}

#  list out all Classifications associated with a Resource
function DisplayClassifications()
{
    global $Resource, $Field, $Value, $GenericId;

    $Classifications = $Resource->Get($Field->Name());
    if (is_array($Classifications))
    {
        foreach ($Classifications as $GenericId => $Value)
        {
            # ignore empty values and NULL values
            if (isset($Value))
            {
                DisplayTextField();
            }
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# display add status, this is also exported
function GetAddStatus()
{
    global $Action;

    if ($Action == "Add Record")
        return "Added";
    else if ($Action == "Duplicate Resource")
        return "Duplicated";
    else if ($Action == "Delete Resource")
        return "Deleted";
    else
        return "Updated";
}

# process Add/Update Resource Record
function AddUpdateResourceRecord()
{
    global $Result, $ResourceId, $Resource, $Action;
    global $User, $Session, $SysConfig;

    $DB = new SPTDatabase();

    $MissingError = NULL;
    $NumberError = NULL;
    $ErrorMessage = NULL;
    $QualifierArray = array();
    $Schema = new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_TEXT | MDFTYPE_PARAGRAPH |
            MDFTYPE_NUMBER | MDFTYPE_DATE | MDFTYPE_TIMESTAMP |
            MDFTYPE_FLAG | MDFTYPE_USER | MDFTYPE_IMAGE | MDFTYPE_OPTION |
            MDFTYPE_CONTROLLEDNAME | MDFTYPE_TREE);

    # loop through each field
    foreach ($Fields as $Field)
    {
        if ($Field->Enabled())
        {
            # extract the field names posted value
            $DBName = $Field->DBFieldName();
            if (isset($_POST["$DBName"]))
                $Value = $_POST["$DBName"];
            else
                $Value = NULL;
#            echo "$DBName = $Value<br>";

            # extract qualifier for this field
            if ($Field->UsesQualifiers() && $Field->HasItemLevelQualifiers()
                && !($Field->Type() &
                (MDFTYPE_CONTROLLEDNAME | MDFTYPE_OPTION | MDFTYPE_TREE)))
            {
                $QualifierField = $DBName."Qualifier";
                if (isset($_POST["$QualifierField"]))
                    $QualifierId = $_POST["$QualifierField"];
                else
                    $QualifierId = NULL;
                $QualifierArray[$Field->Id()] = $QualifierId;
            }

            switch($Field->Type())
            {
                case MDFTYPE_NUMBER:
                    # check min and max for number fields
                    if (is_numeric($Value))
                    {
                        $Min = $Field->MinValue();
                        $Max = $Field->MaxValue();
                        if (isset($Min))
                        {
                            if ($Value < $Field->MinValue())
                            {
                                $NumberError .= $Field->Name().
                                    " < min value ($Min), ";
                            }
                        }
                        if (isset($Max))
                        {
                            if ($Value > $Field->MaxValue())
                            {
                                $NumberError .= $Field->Name().
                                    " > max value ($Max), ";
                            }
                        }
                    }
                    else if (!empty($Value) && is_string($Value))
                    {
                        $NumberError .= $Field->Name().
                            " is not a valid number, ";
                    }
                    # translate empty strings to NULL for numbers
                    if (empty($Value))
                        $Value = NULL;

                    break;

                case MDFTYPE_DATE:
                    # check Dates for valid format
                    if(!empty($Value))
                    {
                        $Date = new SPTDate($Value);

                        # check for invalid Date format
                        if ($Date->BeginDate() == "0000-00-00")
                        {
                            $DateError .= $Field->Name().
                                " is not a valid date format, ";
                        }
                        else
                            $Value = $Date;
                    }
                    break;

                case MDFTYPE_IMAGE:
                    # update Alt Text
                    $SPTImage = $Resource->GetByField($Field, TRUE);
                    if (is_object($SPTImage))
                    {
                        $DBName = $DBName."AltText";
                        $Value = $_POST["$DBName"];
                        $SPTImage->AltText($Value);
                        $Value = $SPTImage->Id();
                    }
                    else
                        $Value = 0;
                    break;

                case MDFTYPE_USER:
                    # Don't change AddedById except for initial Add
                    if ($Action != "Add Record" && $DBName == "AddedById")
                        $Value = $Resource->Get("Added By Id", $Value);
                    else
                        $Value = $User;
                    break;

                case MDFTYPE_CONTROLLEDNAME:
                    # cache current values
                    $Value = $Resource->GetByField($Field);

                    # clear current values
                    $Resource->ClearByField($Field);

                    # process new style ControlledNames
                    reset($_POST);
                    $NewValue = array();
                    while (list($Var, $Val) = each($_POST))
                    {
                        if (ereg("^${DBName}([0-9]+)", $Var, $Regs))
                        {
                            # match found, so destroy cache
                            $Value = array();
                            $CN = new ControlledName($Val);
                            if ($CN->Status() == CNSTAT_OK)
                                $NewValue[$Val] = $CN->Name();
                        }
                    }
                    # load in new values if needed
                    if (count($NewValue))
                        $Value = $NewValue;
                    break;

                case MDFTYPE_TREE:
                    # cache current values
                    $Value = $Resource->GetByField($Field);

                    # clear current values
                    $Resource->ClearByField($Field);

                    # process new style Classifications
                    reset($_POST);
                    $ClassFactory = new ClassificationFactory($Field->Id());
                    $NewValue = array();
                    while (list($Var, $Val) = each($_POST))
                    {
                        if (ereg("^${DBName}([0-9]+)", $Var, $Regs))
                        {
                            # match found, so destroy cache
                            $Value = array();

                            # if field falls within option list threshold
                            if ($ClassFactory->GetItemCount() <= 250)
                            {
                                # attemt to load classification
                                $Class = $ClassFactory->GetItem($Val);
                                if ($Class->Status() == CLASSSTAT_OK)
                                {
                                    $NewValue[$Val] = $Class->FullName();
                                }
                            }
                            else
                            {
                                # attempt to find classification
                                if (strlen(trim($Val)))
                                {
                                    $Class = $ClassFactory->GetItemByName(trim($Val));
                                    if ($Class !== NULL)
                                        $NewValue[$Class->Id()] = $Class->FullName();
                                }
                            }
                        }
                    }
                    # load in new values if needed
                    if (count($NewValue))
                        $Value = $NewValue;
                    break;

                case MDFTYPE_OPTION:
                    $Resource->ClearByField($Field);
                    if (is_array($Value))
                    {
                        $NewValue = array();
                        foreach ($Value as $Id)
                        {
                            $CN = new ControlledName($Id);
                            if ($CN->Status() == CNSTAT_OK)
                                $NewValue[$Id] = $CN->Name();
                        }
                        $Value = $NewValue;
                     }
                     break;

                case MDFTYPE_TEXT:
                        # strip out unwanted tags, include <br>
                        $Value = trim($Value);
                        $Value = str_replace(array("< ", " >"),
                            array("&lt; ", " &gt;"), $Value);
                        $Value = strip_tags($Value,
                            '<a><b><i><u><p><q><s><pre><sub><sup>');
                        $Value = str_replace(array("&lt; ", " &gt;"),
                            array("< ", " >"), $Value);
                    break;

                case MDFTYPE_PARAGRAPH:
                        # strip out unwanted tags, allow <br> for paragraphs
                        $Value = trim($Value);
                        $Value = str_replace(array("< ", " >"),
                            array("&lt; ", " &gt;"), $Value);
                        $Value = strip_tags($Value,
                            '<a><b><i><u><p><q><s><br><pre><sub><sup>');
                        $Value = str_replace(array("&lt; ", " &gt;"),
                            array("< ", " >"), $Value);
                    break;

                case MDFTYPE_FLAG:
                    if ($Field->Name() == "Release Flag")
                    {
                        $ReleaseFlagBefore = $Resource->GetByField($Field);
                        $ReleaseFlagAfter = $Value;
                    }
                    break;

                case MDFTYPE_TIMESTAMP:
                default:
                    break;
            }

            # ERROR Checks follow
            # check for required fields (not optional, ignore timestamps)
            if (!$Field->Optional() && !($Field->Type() &
                (MDFTYPE_TIMESTAMP | MDFTYPE_FLAG | MDFTYPE_USER)))
            {
                # ignore empty flags or users
                if (empty($Value))
                {
                    $MissingError .= $Field->Name().", ";
                }
            }

            # cache FieldId and Value for setting below
            $ResourceArray[$Field->Id()] = $Value;
        }
    }

    # only report errors if adding or updating
    if ($Action == "Add Record" || $Action == "Update Resource")
    {
        # report missing required fields
        if (!empty($MissingError))
        {
            $ErrorMessage = "Error: Missing required field(s): ".$MissingError;
            $ErrorMessage = substr($ErrorMessage, 0, strlen($ErrorMessage) - 2);
            $ErrorMessage .= "<br>";
        }

        # report min/max violations
        if (!empty($NumberError))
        {
            $ErrorMessage .= "Error: Number is invalid or fails limits:<br>".
            $NumberError;
            $ErrorMessage = substr($ErrorMessage, 0, strlen($ErrorMessage) - 2);
            $ErrorMessage .= "<br>";
        }

        # report date errors
        if (!empty($DateError))
        {
            $ErrorMessage .= "Error: Date field is invalid:<br>".$DateError;
            $ErrorMessage = substr($ErrorMessage, 0, strlen($ErrorMessage) - 2);
            $ErrorMessage .= "<br>";
        }

        # display error messages
        if (!empty($ErrorMessage))
        {
            $ErrorMessage .= "Please select Back and correct.";
            ErrorOut($ErrorMessage);
        }
    }

    # now set each Resource field
    foreach ($ResourceArray as $FieldId => $Value)
    {
        $Resource->SetByFieldId($FieldId, $Value);
    }

    # set item level qualifiers
    foreach ($QualifierArray as $FieldId => $Value)
    {
        $Resource->SetQualifierByFieldId($FieldId, $Value);
    }

    if ($Action == "Add Record")
    {
        # force date of Record Creation to current time
        $Resource->Set("Date Of Record Creation", date("Y-m-d H:i:s"));

        # work to do if a temp resource
        if ($Resource->IsTempResource() && $Action == "Add Record")
        {
            # now convert from a temp resource to a real resource
            $Resource->IsTempResource(FALSE);
            $ResourceId = $Resource->Id();
        }
    }

    # set Date Of Record Release if appropriate
    if ($ReleaseFlagBefore == 0 && $ReleaseFlagAfter == 1)
    {
        $Resource->Set("Date Of Record Release", date("Y-m-d H:i:s"));
    }

    # force date last modified to current time
    $Resource->Set("Date Last Modified", date("Y-m-d H:i:s"));

    # query out added record for displaying results
    $Result = $Resource->GetAsArray();

    # only update search and recommender dbs if doing a true add or update
    if ($Action == "Add Record" || $Action == "Update Resource")
    {
        if ($SysConfig->SearchDBEnabled())
        {
            # update search DB for this record
            $SearchEngine = new SPTSearchEngine();
            $SearchEngine->UpdateForResource($ResourceId);
        }

        if ($SysConfig->RecommenderDBEnabled())
        {
            # update recommender DB for this record
            $Recommender = new SPTRecommender();
            $Recommender->UpdateForItem($ResourceId);
        }
    }
}

# add more classifications
function AddMoreClassifications()
{
    global $Session;
    global $Field;

    $Session->PassVariable("F_FieldId", $Field->Id());
    PrintAutoRefreshPage("Search Classifications",
        "SPT--SearchClassification.php");
    exit;
}

# assign or remove controlled names to the resource
function AddMoreControlledNames($Name)
{
    global $ResourceId, $Session, $Schema;

    # get the controlledname type by stripping off trailing "s"
    $Field = $Schema->GetFieldByName($Name);

    $Session->PassVariable("F_FieldId", $Field->Id());
    PrintAutoRefreshPage("Search Controlled Names",
        "SPT--SearchControlledName.php");
    exit;
}

function RemoveCheckedItems($Name)
{
    global $Resource, $ResourceId, $_POST, $Session, $Schema;

    $Id = array();

    $Field = $Schema->GetFieldByName($Name);

    reset($_POST);
    while (list($Var, $Value) = each ($_POST))
    {
        if (ereg("del_id_([0-9]+)", $Var, $Regs))
        {
            if (!empty($Value))
            {
                $Id[$Value] = $Value;
            }
        }
    }
    $Resource->Clear($Name, $Id);

    foreach ($Id as $Dummy => $Value)
    {
        if ($Field->Type() == MDFTYPE_TREE)
        {
            # update Classification resource count
            $Class = new Classification($Value);
            $Class->RecalcResourceCount();
        }
    }

    # return to the entry screen
    PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
    exit;
}

# process images
function UploadImage()
{
    global $NavDirCorrection, $Session, $Resource, $ResourceId;

    # Get the schema
    $Schema = new MetadataSchema();
    $DB = new SPTDatabase();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_IMAGE);

    foreach ($Fields as $Field)
    {
        if ($Field->Enabled())
        {
            $Name = $Field->DBFieldName();
            $AltText = $Field->DBFieldName()."AltText";

            $ImageStorageDir = dirname(GetScriptFileName()).
                "/".$NavDirCorrection."ImageStorage/";
            $PreviewDir = $ImageStorageDir."Previews";
            $ThumbnailDir = $ImageStorageDir."Thumbnails";

            if (!is_writable($ImageStorageDir))
            {
                $ErrorMessage = "Error: ".
                        $ImageStorageDir." is not writable.<br>";
            }
            if (!is_writable($PreviewDir))
            {
                $ErrorMessage .= "Error: ".
                        $PreviewDir." is not writable.<br>";
            }
            if (!is_writable($ThumbnailDir))
            {
                $ErrorMessage .= "Error: ".
                        $ThumbnailDir." is not writable<br>.";
            }
            if (!empty($ErrorMessage))
            {
                $ErrorMessage .= "Please select Back and correct.";
                ErrorOut($ErrorMessage);
            }

            $TempFile = $ImageStorageDir.$_FILES[$Name]['name'];

            # open import file for reading
            if (is_uploaded_file($_FILES[$Name]['tmp_name']))
            {
                copy($_FILES[$Name]['tmp_name'], $TempFile);

                $Image = new SPTImage($TempFile,
                    $Field->MaxPreviewWidth(), $Field->MaxPreviewHeight(),
                    $Field->MaxThumbnailWidth(), $Field->MaxThumbnailHeight());

                $Status = $Image->Status();

                switch ($Status)
                {
                    case AI_FILEUNREADABLE:
                        $ErrorMessage =
                            "Uploaded file is not readable.";
                        break;

                    case AI_IMGOBJCREATEFAILED:
                        $ErrorMessage =
                            "Image object creation failed.";
                        break;

                    case AI_PPMCMDFAILED:
                        $ErrorMessage =
                            "PPM command failed.";
                        break;

                    case AI_INTERNALERROR:
                        $ErrorMessage =
                            "An internal error occurred.";
                        break;

                    case AI_UNKNOWNTYPE:
                    case AI_UNSUPPORTEDFORMAT:
                        $ErrorMessage =
                            "Uploaded file is not in a supported format.";
                        break;

                    case AI_DESTINATIONUNWRITABLE:
                        $ErrorMessage = "Destination is not writable.";
                        break;

                    case AI_OKAY:
                        break;
                }

                # image creation failed
                if (!empty($ErrorMessage))
                {
                    $ErrorMessage = "ERROR: ".$ErrorMessage;
                    $ErrorMessage .= "<br>Please select Back and correct.";
                    ErrorOut($ErrorMessage);
                }

                # set AltText
                $Image->AltText($_POST["$AltText"]);

                # remove temp files
                unlink($_FILES[$Name]['tmp_name']);
                unlink($TempFile);

                $Resource->Set($Field->Name(), $Image->Id());
            }
            # no file name entered, just return
            else if (empty($_FILES[$Name]['name']))
            {
            }
            else
            {
                $ErrorMessage = "Possible file upload attack.".
                        "<BR>Filename: " .$_FILES[$Name]['name'];
                ErrorOut($ErrorMessage);
            }
        }
    }
    # return to Entry screen
    PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
    exit;
}

# process uploaded file(s)
function UploadFiles($Resource, $User)
{
    # for each metadata field that might have an uploaded file
    $Schema = new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_FILE);
    foreach ($Fields as $Field)
    {
        # if field is modifiable by specified user
        #       and we have an uploaded file for this field
        if ($Resource->UserCanEditField($User, $Field)
                && isset($_FILES[$Field->DBFieldName()]["tmp_name"])
                && is_uploaded_file($_FILES[$Field->DBFieldName()]["tmp_name"]))
        {
            # save uploaded file
            $TmpFileName = $_FILES[$Field->DBFieldName()]["tmp_name"];
            $NewFile = new File($TmpFileName, $Resource->Id(), $Field->Id(),
                    $_FILES[$Field->DBFieldName()]["name"]);

            # if file save failed
            if ($NewFile->Status() != FILESTAT_OK)
            {
                # set error message and error out
                switch ($NewFile->Status())
                {
                    case FILESTAT_COPYERROR:
                        $ErrorMessage = "ERROR: A problem occurred during file"
                                ." upload for ".$Field->Name().". (FILESTAT_COPYERROR)";
                        break;

                    case FILESTAT_PARAMERROR:
                        $ErrorMessage = "ERROR: A problem occurred during file"
                                ." upload for ".$Field->Name().". (FILESTAT_PARAMERROR)";
                        break;

                    case FILESTAT_ZEROLENGTH:
                        $ErrorMessage = "ERROR: The file you attempted to upload"
                                ." for ".$Field->Name()." was empty (zero length).<br>"
                                ."<br>"
                                ."Please use your browser's <i>Back</i> button to"
                                ." return to the resource editing page and correct"
                                ." the error.";
                        break;

                    default:
                        $ErrorMessage = "ERROR: A problem occurred during"
                                ." file upload. (OTHER)";
                        break;
                }
                ErrorOut($ErrorMessage);
            }

            # remove temp file
            unlink($TmpFileName);
        }
    }
}

# process file deletion requests
function DeleteFiles($Resource, $User)
{
    # for each metadata field that might have files to be deleted
    $Schema = new MetadataSchema();
    $Fields = $Schema->GetFields(MDFTYPE_FILE);
    foreach ($Fields as $Field)
    {
        # if field is modifiable by specified user
        if ($Resource->UserCanEditField($User, $Field))
        {
            # retrieve files loaded for this field and resource
            $Files = $Resource->GetByField($Field, TRUE);

            # for each file
            foreach ($Files as $File)
            {
                # if delete button was pushed for this file
                if (isset($_POST["DeleteFile".$File->Id()]))
                {
                    # delete file
                    $File->Delete();
                }
            }
        }
    }
}

# duplicate Resource Record
function DuplicateResourceRecord()
{
    global $ResourceId, $Resource, $Result, $User, $SysConfig;

    $ResourceFactory = new ResourceFactory();
    $NewResource = $ResourceFactory->DuplicateResource($ResourceId);
    $Title = $NewResource->Get("Title");

    # convert new temp resource to a real resource
    $NewResource->IsTempResource(FALSE);
    $NewResource->Set("Title", $Title."  (DUPLICATE)");
    $NewResource->Set("Date Of Record Creation", date("Y-m-d H:i:s"));
    $NewResource->Set("Date Last Modified", date("Y-m-d H:i:s"));
    $NewResource->Set("Added By Id", $User);
    $NewResource->Set("Last Modified By Id", $User);
    $Resource = $NewResource;
    $Result = $Resource->GetAsArray();
    $ResourceId = $Resource->Id();

    if ($SysConfig->SearchDBEnabled())
    {
        # update search DB for this record
        $SearchEngine = new SPTSearchEngine();
        $SearchEngine->UpdateForResource($ResourceId);
    }

    if ($SysConfig->RecommenderDBEnabled())
    {
        # update recommender DB for this record
        $Recommender = new SPTRecommender();
        $Recommender->UpdateForItem($ResourceId);
    }
}

# delete a record
function ConfirmDeleteResource()
{
    global $Session, $ResourceId;

    # go to confirm delete screen
    PrintAutoRefreshPage("Delete Resource", "SPT--ConfirmDeleteRecord.php");
    exit;
}

function DeleteResource()
{
    global $Resource;

    $Resource->Delete();
}

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_MYRESOURCEADMIN, PRIV_RELEASEADMIN);

$Schema = new MetadataSchema();

if (isset($_POST["ResourceId"]))
    $ResourceId = $_POST["ResourceId"];
else
    $ResourceId = $Session->Get("ResourceId");

# grab existing resource
$RFactory = new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();
$Resource = new Resource($ResourceId);

# find out which button was selected
if (isset($_POST["Submit"]))
    $Submit = $_POST["Submit"];
elseif ( isset($_POST["HiddenSubmit"]) )
    $Submit = $_POST["HiddenSubmit"];
if (isset($_POST["Definition"]))
    $Definition = $_POST["Definition"];

# get first two words of submit button to determine action
$Words = explode(" ", $Submit);
$Action = $Words[0];
if (isset($Words[1]))
    $Action .= " ".$Words[1];

# get controlled name or image name
if (isset($Words[2]))
    $Begin = strpos($Submit, $Words[2]);
else
    $Begin = 0;

# get third word and everything beyond less trailing 's'
$FieldName = substr($Submit, $Begin);
$FieldName = substr($FieldName, 0, strlen($FieldName) - 1);
if ($Words[0] == "Add" && $Words[1] == "More" && !empty($FieldName))
{
    $Field = $Schema->GetFieldByName($FieldName);
    if ($Field->Type() == MDFTYPE_TREE)
        $Action .= " Classifications";
}

# strip off trailing "s" for ControlledNames only
if (isset($Words[1]) && $Words[1] == "Image")
    $Name = substr($Submit, $Begin, strlen($Submit)-$Begin);
else
    $Name = substr($Submit, $Begin, strlen($Submit)-$Begin-1);

# field definition link selected
if (isset($_GET["FieldId"]))
{
    AddUpdateResourceRecord();
    $Session->PassVariable("FieldId", $_GET["FieldId"]);
    PrintAutoRefreshPage("Field Definition", "SPT--FieldDefinition.php");
    exit;
}

switch($Action)
{
    case "Add Record":
        AddUpdateResourceRecord();
        $RFactory->ClearCurrentEditedItemId();
        break;

    case "Update Resource":
        AddUpdateResourceRecord();
        $RFactory->ClearCurrentEditedItemId();
        break;

    case "Duplicate Resource":
        DuplicateResourceRecord();
        $RFactory->ClearCurrentEditedItemId();
        break;

    case "Delete Resource":
        # only Delete when fourth word exists = Title of Resource
        if (empty($Words[3]))
            ConfirmDeleteResource();
        else
        {
            DeleteResource();
            $RFactory->ClearCurrentEditedItemId();
        }
        break;

    case "Delete Resource":
        DeleteResource();
        break;

    # classifications (trees)
    case "Add More Classifications":
        AddUpdateResourceRecord();
        AddMoreClassifications();
        break;

    # controlled names
    case "Add More":
        AddUpdateResourceRecord();
        AddMoreControlledNames($Name);
        break;

    # controlled names and classifications
    case "Remove Checked":
        AddUpdateResourceRecord();
        RemoveCheckedItems($Name);
        break;

    case "Upload Image":
        AddUpdateResourceRecord();
        UploadImage();
        break;

    case "Upload File":
        AddUpdateResourceRecord();
        UploadFiles($Resource, $User);
        PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
        exit(0);
        break;

    case "Delete Image":
        AddUpdateResourceRecord();
        $Resource->Clear($Name);
        PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
        exit;
        break;

    case "Cancel":
        if ($Resource->IsTempResource())
        {
            $Resource->Delete();
        }
        $RFactory->ClearCurrentEditedItemId();
        PrintAutoRefreshPage("Cancelling Resource Editing", "SPT--MDHome.php");
        exit;
        break;

    default:
        DeleteFiles($Resource, $User);
        PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
        exit;
        break;
}

PageTitle("Record " .GetAddStatus());
include("include/SPT--StandardHtmlPageLoad.php");

?>
