<?php
#
#   FILE:  SPT--SearchClassification.php
#
#   FUNCTIONS PROVIDED:
#       PrintResourceId()
#       - print out ResourceId
#
#       DisplayClassificationInfo()
#       - displays classification info from a query
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--ResourceFactory.php");
require_once("include/SPT--ClassificationFactory.php");
require_once("include/SPT--MetadataSchema.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# function to print out Resource Id
function ClassificationsExist()
{
    global $NumRows;

    return $NumRows;
}

# function to see if Form variable F_Class is empty or not
function SearchEntered()
{
    global $F_Class;

    return (empty($F_Class)) ? false : true;
}

# more controlled names to display?
function PreviousClassesAvailable()
{
    global $Offset;

    return ($Offset >= 250) ? TRUE : FALSE;
}

# previous controlled names to display
function NextClassesAvailable()
{
    global $NumRows;
    
    return ($NumRows <= 250) ? FALSE : TRUE;
}

# print previous link
function PrintPrevLink()
{
    global $SysConfig;
    global $Offset;

    $NewOffset = $Offset - 250;
    print "SPT--SearchClassification.php?Offset=$NewOffset";
}

# print next link
function PrintNextLink()
{
    global $SysConfig;
    global $Offset;

    $NewOffset = $Offset + 250;
    print "SPT--SearchClassification.php?Offset=$NewOffset";
}

# function to print error message
function PrintErrorMessage()
{
    global $Session;

    $ErrorMessage = $Session->Get("ErrorMessage");

    if (!empty($ErrorMessage))
    {
        print("<ul>\n");
        printf("<li><b>%s</b></li>\n", $ErrorMessage);
        print("</ul>\n");
    }
}

# function to return if Existing Resource Record or Not
function ExistingResource()
{
    global $ResourceId;

    return ($ResourceId > 0) ? true : false;
}

# return if true if F_FieldId specified, else false
function FieldIdSet()
{
    global $F_FieldId;

    return ($F_FieldId != 0) ? true : false; 
}

# print F_FieldId 
function PrintFieldId()
{
    global $F_FieldId;

    print $F_FieldId;
}

# function to print ClassificationName
function PrintClassificationName()
{
    global $ClassificationName;

    print stripslashes($ClassificationName);
}

# function to print Field name 
function PrintFieldName()
{
    global $Field;

    print $Field->Name();
}

# function to print ClassificationId
function PrintClassificationId()
{
    global $ClassificationId;

    print $ClassificationId;
}

# function to print ClassificationId
function PrintIndex()
{
    global $Index;

    print $Index;
}

# function to print ResourceCount 
function PrintResourceCount()
{
    global $ResourceCount;

    print $ResourceCount;
}

# function to print F_Class 
function PrintFClass()
{
	global $F_Class;

	print isset($F_Class) ? $F_Class : "";
}

# display classification info
function DisplayClassificationInfo()
{
    global $F_Class;
    global $F_FieldId;
    global $User;
    global $ResourceId;
    global $NumRows;
    global $Index;
    global $ResourceCount;
    global $ClassificationName;
    global $ClassificationId;
    global $Field;
    global $Offset;

    if (empty($F_Class))
    {
        $ClassFactory = new ClassificationFactory();
        $ClassIds = $ClassFactory->GetItemIds("FieldId = $F_FieldId ".
                "ORDER BY ClassificationName LIMIT $Offset, 251");
    }
    else
    {
        $ClassFactory = new ClassificationFactory($F_FieldId);
        $F_Class = stripslashes($F_Class);
        $ClassNames = $ClassFactory->SearchForItemNames($F_Class, 240);
        $ClassIds = array_keys($ClassNames);
    }
    
    $NumRows = count($ClassIds);
     
    if ($NumRows > 0)
    {
        $LongestNameLen = 0;
        for ($Index = 0;  $Index < min($NumRows, 250);  $Index++)
        {
            $Class[$Index] = new Classification($ClassIds[$Index]);
            $ClassificationName = $Class[$Index]->FullName();
            $LongestNameLen = max($LongestNameLen, strlen($ClassificationName));
        }
        $NumColumns = ($LongestNameLen > 50) ? 1 : (($LongestNameLen > 25) ? 2 : 3);
        DisplayHeading();
        $SavedOffset = $Offset;
        StartRow();
        for ($Index = 0;  $Index < min($NumRows, 250);  $Index++)
        {
            $ClassificationName = $Class[$Index]->FullName();
            $ClassificationId = $Class[$Index]->Id();
            $ResourceCount = $Class[$Index]->ResourceCount();
            $QualifierId = $Class[$Index]->QualifierId();
            DisplayClassificationSelection();
            if ((($Index + 1) % $NumColumns) == 0)
            {
                EndRow();
                StartRow();
            }
        }
        # add end row if needed
        if ($Index % 3)
            EndRow();
        $Offset = $SavedOffset;
        DisplayAssignButtons();
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_MYRESOURCEADMIN);

$Schema = new MetadataSchema();
$NavDirCorrection = "../";

# get currently edited resource
$RFactory = new ResourceFactory();
$ResourceId = $RFactory->GetCurrentEditedItemId();

if (isset($_GET["Offset"]))
    $Offset = $_GET["Offset"];
else
    $Offset = 0;

if (isset($_GET["F_FieldId"]))
    $F_FieldId = $_GET["F_FieldId"];
else
    $F_FieldId = $Session->Get("F_FieldId");

# class is gotten from previous form
if (isset($_POST["F_Class"]))
{
    $F_Class = trim(stripslashes($_POST["F_Class"]));
}

# Determine which tree we should search
$Field = $Schema->GetField($F_FieldId);
$Session->PassVariable("F_FieldId", $F_FieldId);

# handle Cancel button
if (isset($_POST["Submit"]) && $_POST["Submit"] == "Cancel")
{
    PrintAutoRefreshPage("Edit Resource", "SPT--DBEntry.php");
    exit;
}

PageTitle("Assign Classifications (".$Field->Name().")");
include("include/SPT--StandardHtmlPageLoad.php");


?>
