<?PHP
#
#   FILE:  SPT--RegisterPortal.php
#
#   FUNCTIONS PROVIDED:
#       PrintRegistrationInfo()
#           - print list of info that will be sent when registering
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   OPTIONAL FUNCTIONS:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       (none)
#
#   Part of the Scout Portal Toolkit
#   Copyright 2004 Internet Scout Project
#   http://scout.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--ResourceFactory.php");
require_once("include/SPT--ClassificationFactory.php");
require_once("include/SPT--SearchEngine.php");
require_once("Axis--Database.php");

PageTitle("Register Portal");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# print list if info that will be sent when registering
function PrintRegistrationInfo()
{
    global $SysConfig;
    global $_SERVER;
    global $SPT_SoftwareVersionToDisplay;

    # general site info
    print("Software: ".(SoftwareIsCWIS() ? "CWIS" : "SPT")." ".$SPT_SoftwareVersionToDisplay."<br>\n");
    print("Site Name: <i>".$SysConfig->PortalName()."</i><br>\n");
    print("Site URI: <i>".$_SERVER["SERVER_NAME"].dirname($_SERVER["REQUEST_URI"])."</i><br>\n");
    print("Admin E-Mail: <i>".$SysConfig->AdminEmail()."</i><br>\n");

    # configuration settings
    print("Default UI: ".$SysConfig->DefaultActiveUI()."<br>\n");
    print("Current Theme: ".$SysConfig->CurrentTheme()."<br>\n");
    print("Forums: ".($SysConfig->ForumsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("User Agents: ".($SysConfig->UserAgentsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Announcements: ".($SysConfig->AnnouncementsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Multiple UIs: ".($SysConfig->AllowMultipleUIsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Ratings: ".($SysConfig->ResourceRatingsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Comments: ".($SysConfig->ResourceCommentsEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Search Update: ".($SysConfig->SearchDBEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Recommender Update: ".($SysConfig->RecommenderDBEnabled() ? "ENABLED" : "DISABLED")."<br>\n");
    print("Search Logic: ".($SysConfig->SearchTermsRequired() ? "AND" : "OR")."<br>\n");

    # resources info
    $RFactory = new ResourceFactory();
    $ResourceCount = $RFactory->GetItemCount();
    print("Resource Count: ".$ResourceCount."<br>\n");
    $ReleasedResourceCount = $RFactory->GetItemCount("ReleaseFlag = 1");
    print("Released Count: ".$ReleasedResourceCount."<br>\n");
    $RatedResourceCount = $RFactory->GetRatedResourceCount();
    print("Rating Count: ".$RatedResourceCount."<br>\n");

    $ClassFactory = new ClassificationFactory();
    $ClassCount = $ClassFactory->GetItemCount();
    print("Classification Count: ".$ClassCount."<br>\n");

    $SampleCount = $RFactory->GetItemCount("INSTR(Description, '[--SAMPLE RECORD--]') > 0");
    print("Sample Count: ".$SampleCount."<br>\n");

    $SearchEngine = new SPTSearchEngine();
    $TermCount = $SearchEngine->SearchTermCount();
    print("Search Term Count: ".$TermCount."<br>\n");

    # PHP configuration
    print("PHP Version: ".phpversion()."<br>\n");
    $PhpInfo = GetPhpInfo();
	
	if (isset($PhpInfo[""]["safe_mode"][0])) { print("PHP safe_mode: ".$PhpInfo[""]["safe_mode"][0]."<br>\n"); }
    if (isset($PhpInfo[""]["register_globals"][0])) { print("PHP register_globals: ".$PhpInfo[""]["register_globals"][0]."<br>\n"); }
    if (isset($PhpInfo[""]["max_execution_time"][0])) { print("PHP max_execution_time: ".$PhpInfo[""]["max_execution_time"][0]."<br>\n"); }
    if (isset($PhpInfo[""]["memory_limit"][0])) { print("PHP memory_limit: ".$PhpInfo[""]["memory_limit"][0]."<br>\n"); }
    if (isset($PhpInfo[""]["post_max_size"][0])) { print("PHP post_max_size: ".$PhpInfo[""]["post_max_size"][0]."<br>\n"); }
    if (isset($PhpInfo[""]["file_uploads"][0])) { print("PHP file_uploads: ".$PhpInfo[""]["file_uploads"][0]."<br>\n"); }
    if (isset($PhpInfo[""]["upload_max_filesize"][0])) { print("PHP upload_max_filesize: ".$PhpInfo[""]["upload_max_filesize"][0]."<br>\n"); }
	
    $Val = isset($PhpInfo["gd"]["GD Version"][0]) ? $PhpInfo["gd"]["GD Version"][0] : "unavailable";
    print("PHP GD version: ".$Val."<br>\n");
    $Val = (isset($PhpInfo["gd"]["PNG Support"][0])) ? $PhpInfo["gd"]["PNG Support"][0] : "unavailable";
    print("PHP GD PNG Support: ".$Val."<br>\n");
    $Val = (isset($PhpInfo["gd"]["JPG Support"][0])) ? $PhpInfo["gd"]["JPG Support"][0] : "unavailable";
    print("PHP GD JPG Support: ".$Val."<br>\n");
    $Val = (isset($PhpInfo["gd"]["GIF Support"][0])) ? $PhpInfo["gd"]["GIF Support"][0] : "unavailable";
    print("PHP GD GIF Support: ".$Val."<br>\n");
	
    # operating environment
    print("MySQL Client Version: ".mysqli_get_client_info()."<br>\n");
    #print("MySQL Server Version: ".mysqli_get_server_info()."<br>\n");
    #print("MySQL Connection Type: ".mysqli_get_host_info()."<br>\n");
    print("HTTP Server: <i>".$_SERVER["SERVER_SOFTWARE"]."</i><br>\n");
    $OSInfo = exec("uname -a");
    print("OS Stamp: <i>".$OSInfo."</i><br>\n");
}

# print current content of user-entered registration settings
function PrintContactName() {  global $SysConfig;  print($SysConfig->ContactName());  }
function PrintContactEmail() {  global $SysConfig;  print($SysConfig->ContactEmail());  }
function PrintOrganization() {  global $SysConfig;  print($SysConfig->Organization());  }
function PrintOrganizationType() {  global $SysConfig;  print($SysConfig->OrganizationType());  }
function PrintSiteType() {  global $SysConfig;  print($SysConfig->SiteType());  }
function PrintOkayToListSite() {  global $SysConfig;  print($SysConfig->OkayToListSite());  }
function PrintCheckedIfOrganizationTypeIs($OrganizationType) {  global $SysConfig;  print(($SysConfig->OrganizationType() == $OrganizationType) ? " checked" : "");  }
function PrintCheckedIfSiteTypeIs($SiteType) {  global $SysConfig;  print(($SysConfig->SiteType() == $SiteType) ? " checked" : "");  }
function PrintCheckedIfOkayToListSite() {  global $SysConfig;  print(($SysConfig->OkayToListSite()) ? " checked" : "");  }


# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization( PRIV_SYSADMIN );
include("include/SPT--StandardHtmlPageLoad.php");

?>
