<?php
#
#   FILE:  SPT--DBEditor.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("include/SPT--Common.php");
require_once("include/SPT--CommonSearch.php");
require_once("include/SPT--MetadataSchema.php");
require_once("include/SPT--Qualifier.php");

CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

PageTitle("Database Editor");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintTextFieldAttributes()
{
    global $Field;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_TEXT, NULL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintTextFieldRow();
    }
}

function PrintParagraphFieldAttributes()
{
    global $Field;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_PARAGRAPH, NULL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintParagraphFieldRow();
    }
}

function PrintNumberFieldAttributes()
{
    global $Field;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_NUMBER, NULL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintNumberFieldRow();
    }
}

function PrintDateFieldAttributes()
{
    global $Field;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_DATE, NULL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintDateFieldRow();
    }
}

function PrintTimestampFieldAttributes()
{
    global $Field;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_TIMESTAMP, NULL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintTimestampFieldRow();
    }
}

function PrintFlagFieldAttributes()
{
    global $Field;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_FLAG, NULL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintFlagFieldRow();
    }
}

function PrintTreeFieldAttributes()
{
    global $Field;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_TREE, NULL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintTreeFieldRow();
    }
}

function PrintContolledNameFieldAttributes()
{
    global $Field;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_CONTROLLEDNAME, NULL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintControlledNameFieldRow();
    }
}

function PrintOptionFieldAttributes()
{
    global $Field;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_OPTION, NULL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintOptionFieldRow();
    }
}

function PrintUserFieldAttributes()
{
    global $Field;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_USER, NULL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintUserFieldRow();
    }
}

function PrintImageFieldAttributes()
{
    global $Field;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_IMAGE, NULL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintImageFieldRow();
    }
}

function PrintFileFieldAttributes()
{
    global $Field;

    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields(MDFTYPE_FILE, NULL, TRUE);

    foreach ($Fields as $Field)
    {
        PrintFileFieldRow();
    }
}

function PrintFieldId()
{
    global $Field;

    print $Field->Id();
}

function PrintFieldName()
{
    global $Field;

    print $Field->Name();
}

function PrintEnabled()
{
    global $Field;

    print GetYesNo($Field->Enabled());
}

function PrintOptional()
{
    global $Field;

    print GetYesNo($Field->Optional());
}

function PrintViewable()
{
    global $Field;

    print GetYesNo($Field->Viewable());
}

function PrintIncludeInKeywordSearch()
{
    global $Field;

    print GetYesNo($Field->IncludeInKeywordSearch());
}

function PrintIncludeInAdvancedSearch()
{
    global $Field;

    print GetYesNo($Field->IncludeInAdvancedSearch());
}

function PrintSearchWeight()
{
    global $Field;

    print $Field->SearchWeight(); 
}

function PrintTextFieldSize()
{
    global $Field;

    print $Field->TextFieldSize();
}

function PrintDefaultValue()
{
    global $Field;

    if ($Field->DefaultValue())
        print $Field->DefaultValue();
    else
        print "[No default value entered for this field]";
}

function PrintUsesQualifiers()
{
    global $Field;

    print GetYesNo($Field->UsesQualifiers());
}

function PrintHasItemLevelQualifiers()
{
    global $Field;

    print GetYesNo($Field->HasItemLevelQualifiers());
}

function PrintDefaultQualifier()
{
    global $Field;

    $DefaultQualifier = $Field->DefaultQualifier();
    if ($DefaultQualifier > 0)
    {
        $Qualifier = new Qualifier($Field->DefaultQualifier());
        print $Qualifier->Name();
    }
    else
        print "--";
}

function PrintDescription()
{
    global $Field;

    print $Field->Description();
}

function PrintParagraphRows()
{
    global $Field;

    print $Field->ParagraphRows();
}

function PrintParagraphCols()
{
    global $Field;

    print $Field->ParagraphCols();
}

function PrintMinValue()
{
    global $Field;

    print $Field->MinValue();
}

function PrintMaxValue()
{
    global $Field;

    print $Field->MaxValue();
}

function PrintFlagOnLabel()
{
    global $Field;

    print $Field->FlagOnLabel();
}

function PrintFlagOffLabel()
{
    global $Field;

    print $Field->FlagOffLabel();
}

function PrintAllowMultiple()
{
    global $Field;

    print GetYesNo($Field->AllowMultiple());
}

function PrintDefaultAltText()
{
    global $Field;

    print $Field->DefaultAltText();
}

function PrintMaxHeight()
{
    global $Field;

    print $Field->MaxHeight();
}

function PrintMaxWidth()
{
    global $Field;

    print $Field->MaxWidth();
}

function PrintMaxPreviewHeight()
{
    global $Field;

    print $Field->MaxPreviewHeight();
}

function PrintMaxPreviewWidth()
{
    global $Field;

    print $Field->MaxPreviewWidth();
}

function PrintMaxThumbnailHeight()
{
    global $Field;

    print $Field->MaxThumbnailHeight();
}

function PrintMaxThumbnailWidth()
{
    global $Field;

    print $Field->MaxThumbnailWidth();
}


function FieldEnabled()
{
    global $Field;

    return $Field->Enabled();
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# translate 1=Yes, 0=No
function GetYesNo($Var)
{
    return ($Var ? "Yes" : "No");
}

# translate flag on or flag off label
function GetFlagValue($Field)
{
    return ($Field->DefaultValue() ? $Field->FlagOnLabel() :
                $Field->FlagOffLabel());
}

# ----- MAIN -----------------------------------------------------------------

include("include/SPT--StandardHtmlPageLoad.php");
?>
