<?PHP
#
#   FILE:  SPT--Advanced.php
#
#   FUNCTIONS PROVIDED:
#       None
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

#require_once("SPT--Advanced.php");
require_once("include/SPT--MetadataSchema.php");

$id = $_GET['id'];									#id del select modificado. -1 = Clear filters
$ForR = isset($_GET['ForR']) ? $_GET['ForR'] : "F";	#F or R: Para conocer si se cambio el F_SearchCat o el R_SearchCat
$condition = "";

if ($id != "-1" && $ForR == "R") {
	$condition = $_GET['val']; 						#categoria seleccionada
	$select_value = $_POST['R_SearchCat'.$id];		#Valor seleccinado
}
$arr = $_GET['arr'];								#FieldList de los select restantes

$array_sel = explode(";", str_replace("_", " ", $arr));		#86,19,27;Keywords,Institution,Classification
$array_key = explode(",", $array_sel[0]);					#86,19,27
$array_value = explode(",", $array_sel[1]);					#Keywords,Institution,Classification

if ($id != "-1" && $ForR == "R") {
	#se reemplaza el id de la categoria por el valor seleccionado en los select
	for ($i = 0; $i < count($array_key); $i++) {
		if ($_POST['R_SearchCat'.$i] != "")
		{ $array_key[$i] = $_POST['R_SearchCat'.$i]; }
	}
}

$FieldList = array_combine($array_key, $array_value);		#array ( 86 => 'Keywords', 19 => 'Institution', 27 => 'Classification', )

$Catalogs = RefreshPrintSearchTextFieldOptionList($FieldList, str_replace("_", " ",$condition));

echo "<script type='text/javascript'>".$Catalogs."</script>";
echo "<script type='text/javascript'>sel_jason = '".str_replace(" ", "_", $array_sel[1])."';</script>";


function RefreshPrintSearchTextFieldOptionList($FieldList, $condition)
{	
    if (!isset($FieldList))
    {
        global $G_User;
        $Schema = new MetadataSchema();
        $Fields = $Schema->GetFields(MDFTYPE_TEXT | MDFTYPE_PARAGRAPH 
                | MDFTYPE_CONTROLLEDNAME | MDFTYPE_NUMBER | MDFTYPE_FILE
                | MDFTYPE_TREE | MDFTYPE_IMAGE | MDFTYPE_DATE | MDFTYPE_TIMESTAMP);
        foreach ($Fields as $FieldId => $Field)
        {
            if ($Field->Enabled() && $Field->IncludeInAdvancedSearch()
                    && ($G_User->HasPriv($Field->ViewingPrivilege())
                        || $G_User->HasPriv($Field->EditingPrivilege())
                        || ($Field->ViewingPrivilege() == 0)))
            {
                $FieldList[$FieldId] = $Field->Name();
            }
        }
		# add in keyword search
		$FieldList["Keyword"] = "Keyword";
    }

    # put field in alphabetical order
    #asort($FieldList);
	
	#Se filtra la lista con lo seleccionado
	$FieldList_filters = $FieldList;
	foreach($FieldList_filters as $key => $val) {
		if (is_numeric($key)){
			unset($FieldList_filters[$key]);
		}
	}
	
	# for each limit of type specified
	$Schema = new MetadataSchema();
	
	$count_filters = count($FieldList_filters);
	$x = 1;
	$last = false;
	$where = "";
	
	if (count($FieldList) > 1)
	{
		foreach($FieldList_filters as $key => $val) {
			if ($x == $count_filters) { $last = true; }
			
			$where .= get_where_list($val, $key, $last, $Schema);			
			$x++;
		}
		for ($r=1; $r<=$count_filters; $r++)
		{
			$where .= " )";
		}
		
		$Catalogs = "";
		foreach($FieldList as $key => $val) {
			if (strcmp($val, $condition) != 0)
			{
				$Catalogs .= "categories['$val'] = [".$Schema->GetList_Refresh($val, $where)."]; ";
			}
		}

		return $Catalogs;
	}
}

function get_where_list($condition, $select_value, $last, $Schema){
	$where = "";
	$inner = "";
	
	$inner = $Schema->get_inner($condition);

	switch($condition)
	{
		case "Classification":
			$where .= " SELECT DISTINCT ResourceClassInts.ResourceId
				FROM ResourceClassInts inner join Classifications on ResourceClassInts.ClassificationId = Classifications.ClassificationId
				WHERE TRIM(ClassificationName) = '".$select_value."' ";
			if (!$last) { $where .= "AND".$inner; }
			break;
		case "ECTS credit points":
			$where .= " SELECT DISTINCT ResourceNameInts.ResourceId
				FROM ControlledNames INNER JOIN ResourceNameInts ON ResourceNameInts.ControlledNameId = ControlledNames.ControlledNameId
				WHERE FieldId = 90 AND TRIM(ControlledName) = '".$select_value."' ";
			if (!$last) { $where .= "AND".$inner; }
			break;
		case "Course coordinator":
			$where .= " SELECT DISTINCT ResourceNameInts.ResourceId
				FROM ControlledNames INNER JOIN ResourceNameInts ON ResourceNameInts.ControlledNameId = ControlledNames.ControlledNameId
				WHERE FieldId = 20 AND TRIM(ControlledName) = '".$select_value."' ";
			if (!$last) { $where .= "AND".$inner; }
			break;
		case "Date end":
			$where .= " SELECT DISTINCT Resources.ResourceId FROM Resources WHERE ReleaseFlag=1 and date_format(DateendBegin, '%Y-%m') = '".$select_value."' ";
			if (!$last) { $where .= "AND".$inner; }
			break;
		case "Date start":
			$where .= " SELECT DISTINCT Resources.ResourceId FROM Resources WHERE ReleaseFlag=1 and date_format(DatestartBegin, '%Y-%m') = '".$select_value."' ";
			if (!$last) { $where .= "AND".$inner; }
			break;
		case "Institution":
			$where .= " SELECT DISTINCT ResourceNameInts.ResourceId
				FROM ControlledNames INNER JOIN ResourceNameInts ON ResourceNameInts.ControlledNameId = ControlledNames.ControlledNameId
				WHERE FieldId = 19 AND TRIM(ControlledName) = '".$select_value."' ";
			if (!$last) { $where .= "AND".$inner; }
			break;
		case "Keywords":
			$where .= " SELECT DISTINCT ResourceNameInts.ResourceId
				FROM ControlledNames INNER JOIN ResourceNameInts ON ResourceNameInts.ControlledNameId = ControlledNames.ControlledNameId
				WHERE FieldId = 86 AND TRIM(ControlledName) = '".$select_value."' ";
			if (!$last) { $where .= "AND".$inner; }
			break;
		case "Mode of delivery":
			$where .= " SELECT DISTINCT ResourceNameInts.ResourceId
				FROM ControlledNames INNER JOIN ResourceNameInts ON ResourceNameInts.ControlledNameId = ControlledNames.ControlledNameId
				WHERE FieldId = 85 AND TRIM(ControlledName) = '".$select_value."' ";
			if (!$last) { $where .= "AND".$inner; }
			break;
		case "Title":
			$where .= " SELECT DISTINCT Resources.ResourceId FROM Resources WHERE ReleaseFlag=1 and TRIM(Title) = '".$select_value."' ";
			if (!$last) { $where .= "AND".$inner; }
			break;
		case "Url":
			$where .= " SELECT DISTINCT Resources.ResourceId FROM Resources WHERE ReleaseFlag=1 and TRIM(Url) = '".$select_value."' ";
			if (!$last) { $where .= "AND".$inner; }
			break;
		/*case "Description":
			$this->DB->Query("");
			while ($Record = $this->DB->FetchRow())
			{
				if ($Lista != "")
					$Lista .= ", ";
				$Lista .= "'".$Record["Data"]."'";
			}
			break;
		case "Email Address":
			$this->DB->Query("");
			while ($Record = $this->DB->FetchRow())
			{
				if ($Lista != "")
					$Lista .= ", ";
				$Lista .= "'".$Record["Data"]."'";
			}
			break;
		case "Focus or specific features":
			$this->DB->Query("SELECT DISTINCT TRIM(Focusorspecificfeatures) AS Data FROM resources ORDER BY Focusorspecificfeatures");
			while ($Record = $this->DB->FetchRow())
			{
				if ($Lista != "")
					$Lista .= ", ";
				$Lista .= "'".$Record["Data"]."'";
			}
			break;
		/*case "Learning Objectives":
			$this->DB->Query("");
			while ($Record = $this->DB->FetchRow())
			{
				if ($Lista != "")
					$Lista .= ", ";
				$Lista .= "'".$Record["Data"]."'";
			}
			break;*/
	}
	
	return $where;
}