<?php
#
#   FILE:  SPT--MetadataHelp3.php
#
#   FUNCTIONS PROVIDED:
#       None.
#
#   FUNCTIONS EXPECTED:
#       None
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

# provide relative path to base SPT directory

$NavDirCorrection = "../";
require_once($NavDirCorrection."include/SPT--Common.php");
require_once($NavDirCorrection."include/SPT--CommonSearch.php");
require_once($NavDirCorrection."include/SPT--MetadataSchema.php");



# ----- EXPORTED FUNCTIONS ---------------------------------------------------

function PrintFieldName()
{
    global $FieldName;

    print $FieldName;
}
function PrintDescription()
{
    global $Description;

    print $Description;
}

function PrintFieldDefinitions()
{
    global $FieldName, $Description;
    
    # Get the schema
    $Schema = new MetadataSchema();

    # Get the fields for the schema
    $Fields = $Schema->GetFields();
    foreach ($Fields as $Field)
    {
        $FieldName = $Field->Name(); 
        $Description = $Field->Description();
        PrintFieldDefinition();
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

CheckAuthorization(PRIV_RESOURCEADMIN, PRIV_SYSADMIN);

#include($NavDirCorrection."include/SPT--StandardHtmlPageLoad.php");


PageTitle("Metadata Tool - Help - Resource Field Definitions");

include(FindUIFile("include/SPT--StandardPageStart.html"));

include(FindUIFile($NavDirCorrection."SPTUI--CWIS/MetadataTool/SPT--MDHelpNav.html"));

#include(CorrespondingHtmlFile());
include(str_replace("/", "/SPTUI--CWIS/MetadataTool/", CorrespondingHtmlFile()) );

include(FindUIFile("include/SPT--StandardPageEnd.html"));

?>

