<?PHP

#
#   FILE:  SPT--EditClassificationComplete.php
#
#   FUNCTIONS PROVIDED:
#       (none)
#
#   FUNCTIONS EXPECTED:
#       (none)
#
#   FORM FIELDS EXPECTED:
#       F_ClassificationId
#           - record ID of classification being edited
#       F_NewSegmentName
#           - edited segment value name
#
#   Part of the Scout Portal Toolkit
#   Copyright 2001 Internet Scout Project
#   http://scout.cs.wisc.edu
#

require_once("../include/SPT--Common.php");
require_once("../include/SPT--Classification.php");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# delete checked records, cache the Ids for now        
function DeleteClassification()
{
    global $ClassId;
    global $Session;

    # confirm removal of classification
    $Session->PassVariable("ClassId", $ClassId);
    PrintAutoRefreshPage("Confirm Delete Classification", 
        "SPT--ConfirmDeleteClassification.php?action=Classification".
        "&target=SPT--EditClassificationComplete.php");
    exit;
}

# delete classifications
function ConfirmDeleteClassification()
{
    global $ClassId;

    $Class = new Classification($ClassId);

    # first delete all child classes -- USER HAS BEEN WARNED!
    $ChildList = $Class->ChildList();
    foreach ($ChildList as $ChildId)
    {
        $ChildClass = new Classification($ChildId);
        $ChildClass->Delete(FALSE, TRUE, TRUE);
    }
    $Class->Delete(FALSE, TRUE, TRUE);
}

# save classifications
function SaveClassification()
{
    global $Class, $_POST, $ErrorMessages;

    $DB = new SPTDatabase();

    # if new classification segment name is valid
    $F_NewSegmentName = trim($_POST["F_NewSegmentName"]);
    if (isset($_POST["F_QualifierId"]))
        $F_QualifierId = $_POST["F_QualifierId"];
    if (strlen($F_NewSegmentName) > 0)
    {
        # save new classification segment name
        $Class->SegmentName($F_NewSegmentName);

        # save qualifier Id
        if (isset($F_QualifierId))
            $Class->QualifierId(($F_QualifierId == "--") ? 0 : $F_QualifierId);

        # rebuild full classification name
        $Class->RecalcDepthAndFullName();
    }
    else
    {
        # add message to error list
        $ErrorMessages = new ErrorList();
        $ErrorMessages->AddMessage(
        "There was an error with the classification segment name you entered.");
    }
}

# ----- MAIN -----------------------------------------------------------------


# check if current user is authorized
CheckAuthorization(PRIV_CLASSADMIN);

$ErrorMessages = $Session->Get("ErrorMessages");
if (isset($_POST["F_ClassificationId"]))
    $ClassId = $_POST["F_ClassificationId"];
else
    $ClassId = $Session->Get("ClassId");

$Submit = $_POST["Submit"];

# clear any old error info
if (isset($ErrorMessages))
{
    unset($ErrorMessages);
    $Session->UnregisterVariable("ErrorMessages");
}

# pull up existing classification record
$Class = new Classification($ClassId);

# check for actual deletion
if ($Submit == "Confirm Delete Classification")
{
    ConfirmDeleteClassification();
}
elseif ($Submit == "Delete Classification")
{
    DeleteClassification();
}
# else if save changes was requested
elseif ($Submit != "Cancel")
{
    SaveClassification();
}

# if errors were found
if (isset($ErrorMessages))
{
    # return to editing page with error messages
    $Session->RegisterVariable("ErrorMessages");
    PrintAutoRefreshPage("Errors Found", 
            "SPT--EditClassification.php?ClassificationId=".$F_ClassificationId);
}
else
{
    # go to classification selection page for parent of edited classification
    PrintAutoRefreshPage("Classification Editing Complete", 
            "../SPT--BrowseResources.php?Editing=1&ParentId="
                    .$Class->ParentId());
}

?>
