<?PHP
#
#   FILE:  ConfirmAutofix.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2011 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------

PageTitle("Confirm an automatic fix to the URL");
CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN);

$MyPlugin = $GLOBALS["G_PluginManager"]->GetPluginForCurrentPage();

$ResourceId = GetFormValue("ResourceId");
$FieldId = GetFormValue("FieldId");
$H_Field = new MetadataField($FieldId);

if (Resource::ItemExists($ResourceId)
        && $H_Field->Status() == MetadataSchema::MDFSTAT_OK)
{
    $H_Resource = new Resource($ResourceId);
    $H_InvalidUrl = $MyPlugin->GetInvalidUrl($H_Resource, $H_Field);

}

else
{
    $AF->SuppressHTMLOutput();
    $AF->SetJumpToPage("index.php?P=P_UrlChecker_Results");
}
