<?PHP
#
#   FILE:  ListRules.php (Rules plugin)
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2016 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis
#

# check authorization to see rule list
CheckAuthorization(PRIV_COLLECTIONADMIN, PRIV_SYSADMIN);

# retrieve sort parameters from URL
$DefaultSortField = "Name";
$SortField = GetFormValue(TransportControlsUI::PNAME_SORTFIELD, $DefaultSortField);
$ReverseSort = GetFormValue(TransportControlsUI::PNAME_REVERSESORT, FALSE);

# determine list sort direction
if ($SortField == $DefaultSortField)
{
    $SortAscending = $ReverseSort ? FALSE : TRUE;
}
else
{
    $SortAscending = $ReverseSort ? TRUE : FALSE;
}

# load rule IDs
$RFactory = new Rules_RuleFactory();
$ItemIds = $RFactory->GetItemIds(NULL, FALSE, $SortField, $SortAscending);

# get total number of items
$H_ItemCount = count($ItemIds);

# get where we currently are in list
$H_StartingIndex = GetFormValue(TransportControlsUI::PNAME_STARTINGINDEX, 0);

# calculate ID array checksum and reset paging if list has changed
$H_ListChecksum = md5(serialize($ItemIds));
if ($H_ListChecksum != GetFormValue("CK")) {  $H_StartingIndex = 0;  }

# prune page IDs down to just currently-selected segment
$H_ItemsPerPage = 25;
$ItemIds = array_slice($ItemIds, $H_StartingIndex, $H_ItemsPerPage);

# load items from IDs
$H_Items = array();
foreach ($ItemIds as $Id)
{
    $H_Items[$Id] = new Rules_Rule($Id);
}

