<?PHP
#
#   FILE:  TransferFolders.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2015 Internet Scout Project
#   http://scout.wisc.edu/
#

# ----- MAIN -----------------------------------------------------------------
$FolderID = GetArrayValue($_GET, "FID");
$NewUserName = GetArrayValue($_POST, "username");
$NewUserID = NULL;
$Plugin = $GLOBALS["G_PluginManager"]->GetPlugin("Folders");
$UserHasPriv = $GLOBALS["G_User"]->HasPriv($Plugin->
        ConfigSetting("PrivsToTransferFolders"));
$IsAjax = ApplicationFramework::ReachedViaAjax();
# create the object to help deal with returning JSON
$JsonHelper = new JsonHelper();

# suppress HTML if we are using AJAX
if ($IsAjax)
{
    $GLOBALS["AF"]->BeginAjaxResponse();
}

# try to retrieve User ID
if ($NewUserName != NULL)
{
    $UserFactory = new UserFactory();
    $NewUserID = key($UserFactory->FindUserNames($NewUserName));
}

# return error messages
if ($FolderID == NULL || !$UserHasPriv || $NewUserName == NULL || $NewUserID == NULL)
{
    if ($IsAjax)
    {
        if ($FolderID == NULL || $NewUserName == NULL)
        {
            $JsonHelper->Error("Folder and new user information not received.");
        }
        elseif ($NewUserID == NULL)
        {
            $JsonHelper->Error("User '" . $NewUserName . "' not found.");
        }
        else
        {
            $JsonHelper->Error("You don't have permission to transfer folders.");
        }
        return;
    }
    else
    {
        if ($FolderID == NULL || $NewUserName == NULL)
        {
            # error: not sufficient informations received
            $ErrorID = 1;
        }
        elseif ($NewUserID == NULL)
        {
            # error: new user not found
            $ErrorID = 2;
        }
        else
        {
            # error: user don't have permission to transfer folder
            $ErrorID = 3;
        }

        $GLOBALS["AF"]->SetJumpToPage("index.php?P=P_Folders_ConfirmFolderTransfer&FID="
                . $FolderID . "&ER=" . $ErrorID);
        return;
    }

}

$Folder = new Folders_Folder($FolderID);
if ($Folder->OwnerID() != $GLOBALS["G_User"]->Id())
{
    if ($IsAjax)
    {
        $JsonHelper->Error("You are not the owner of the folder.");
        return;
    }
    else
    {
        # error: user is not the owner of the folder
        $GLOBALS["AF"]->SetJumpToPage("index.php?P=P_Folders_ConfirmFolderTransfer&FID="
                . $FolderID . "&ER=4");
        return;
    }
}

if ($Folder->OwnerID() == $NewUserID)
{
    if ($IsAjax)
    {
        $JsonHelper->Error("You cannot transfer this folder to yourself.");
        return;
    }
    else
    {
        # error: user is trying to transfer the folder to himself
        $GLOBALS["AF"]->SetJumpToPage("index.php?P=P_Folders_ConfirmFolderTransfer&FID="
                . $FolderID . "&ER=5");
        return;
    }
}

# first we have to determine if the transferring folder is a "current" folder
$FolderFactory = new Folders_FolderFactory($GLOBALS["G_User"]->Id());
$SelectedFolder = $FolderFactory->GetSelectedFolder();
if ($SelectedFolder->Id() == $FolderID)
{
    # if the transferring folder is a selected folder, deselect it and select
    # some other folder instead
    $ResourceFolder = $FolderFactory->GetResourceFolder();
    $FolderIds = $ResourceFolder->GetItemIds();
    foreach($FolderIds as $NewSelectedFolderId)
    {
        if ($NewSelectedFolderId != $FolderID)
        {
            $FolderFactory->SelectFolder(new Folders_Folder($NewSelectedFolderId));
        }
    }
}

# transfer the folder
$OriginalResourceFolder = $FolderFactory->GetResourceFolder($GLOBALS["G_User"]->Id());
$NewResourceFolder = $FolderFactory->GetResourceFolder($NewUserID);
$OriginalResourceFolder->RemoveItem($FolderID);
$NewResourceFolder->AppendItem($FolderID);

$Folder->OwnerId($NewUserID);

# success
if ($IsAjax)
{
    $JsonHelper->Success("Folder successfully transferred to " . $NewUserName . ".");
}
else
{
    $GLOBALS["AF"]->SetJumpToPage("index.php?P=P_Folders_ConfirmFolderTransfer&FID="
            . $FolderID . "&SC=TRUE");
}