<?PHP

/**
* Display the resource note and either edit or add button for the note
* for the resource in the folder.
* @param string $ResourceNote the note for the resource if it exists, if not, empty string
* @param int $FolderId the ID of the currently active folder
* @param int $ResourceId the ID of the resource for which we are generating the button
* @param string $EditResourceNoteUrl the url for editing the resource note.
*/
function Folders_InsertResourceNote($ResourceNote, $FolderId, $ResourceId, $EditResourceNoteUrl)
{
  ?>
    <!-- BEGIN FOLDER RESOURCE NOTE DISPLAY -->
      <p class="cw-folders-item-note" data-folderid="<?PHP print defaulthtmlentities($FolderId); ?>"
         data-itemid="<?PHP print defaulthtmlentities($ResourceId); ?>">
        <span class="cw-folders-item-notetext"><?PHP print nl2br(defaulthtmlentities($ResourceNote)); ?></span>
<?PHP     if ($ResourceNote)
          {
  // @codingStandardsIgnoreStart
?>         <br />
<?PHP     } ?>
        <a class="cw-button cw-button-constrained cw-button-iconed cw-button-elegant cw-folders-editnote"
           href="<?PHP print defaulthtmlentities($EditResourceNoteUrl); ?>">
          <img class="cw-button-icon" src="<?PHP $GLOBALS["AF"]->PUIFile("note_edit.png"); ?>" alt="" />
<?PHP
          if (!$ResourceNote)
          {
?>
            Add
<?PHP
          }
          else
          {
?>
            Edit
<?PHP
          }
?>
        Note
        </a>
      </p>
    <!-- END FOLDER RESOURCE NOTE DISPLAY -->
  <?PHP
// @codingStandardsIgnoreEnd
}
