<?PHP

class AddThis_Toolbox
{

    /**
     * @const STYLE_* built-in AddThis class names for styling purposes
     */
    const STYLE_DEFAULT = "addthis_default_style";
    const STYLE_32_X_32 = "addthis_32x32_style";
    const STYLE_PILL_COMBO = "addthis_pill_combo_style";

    /**
     * Set the class name of the toolbox.
     * @param $Class class name
     */
    public function SetClass($Class)
    {
        $this->Class = defaulthtmlentities($Class);
    }

    /**
     * Add an HTML attribute for the toolbox. Does not allow setting the class
     * name attribute, see self::SetClass for that.
     * @param $Name HTML attribute name
     * @param $Value HTML attribute value
     */
    public function AddHtmlAttribute($Name, $Value)
    {
        $NormalizedName = strtolower($Name);

        if ($NormalizedName != "class")
        {
            $this->Attributes[$NormalizedName] = $Value;
        }
    }

    /**
     * Add a button to the toolbox.
     * @param $Button an AddThis_Button object
     */
    public function AddButton(AddThis_Button $Button)
    {
        $this->Buttons[] = $Button;
    }

    /**
     * Generate and return the HTML representation of the toolbox.
     * @return the HTML representation of the toolbox
     */
    public function GetHtml()
    {
        $Class = $this->Class;
        $Attributes = $this->Attributes;
        $Buttons = $this->Buttons;

        $Html = "<div class=\"addthis_toolbox ".$Class."\"";

        foreach ($Attributes as $Name => $Value)
        {
            $EscapedValue = defaulthtmlentities($Value);
            $Html .= " ".$Name."=\"".$EscapedValue."\"";
        }

        $Html .= ">";

        foreach ($Buttons as $Button)
        {
            $Html .= $Button->GetHtml();
        }

        $Html .= "</div>";

        return $Html;
    }

    /**
     * Generate and print the HTML representation of the toolbox.
     */
    public function PrintHtml()
    {
        print $this->GetHtml();
    }

    /**
     * @var $Class toolbox class name, with self::STYLE_DEFAULT as the default
     * @var $Attributes array of HTML attributes
     * @var $Buttons array of AddThis_Button objects
     */
    private $Class = self::STYLE_DEFAULT;
    private $Attributes = array();
    private $Buttons = array();

}
