<?PHP
#
#   FILE:  UserList.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# make sure user has needed privileges for user editing
if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_USERADMIN)) {  return;  }

# retrieve current offset into list
$G_StartingIndex = GetFormValue("SI", 0);

# determine result ordering SQL clause
$G_SortField = GetFormValue("SF", "UserName");
$G_SortAscending = GetFormValue("SA", 1);
$SortClause = " ORDER BY `".addslashes($G_SortField)."` "
        .($G_SortAscending ? "ASC" : "DESC")
        .", UserId "
        .($G_SortAscending ? "ASC" : "DESC");

# load IDs of users with specified privilege
$DB = new Database();
$Privilege = (isset($_POST["F_Privilege"]) && ($_POST["F_Privilege"] != -1))
        ? $_POST["F_Privilege"]
        : ((isset($_GET["F_Privilege"]) && ($_GET["F_Privilege"] != -1))
        ? $_GET["F_Privilege"]
        : NULL);
if ($Privilege !== NULL)
{
    $Query = "SELECT DISTINCT AU.UserId"
            ." FROM APUsers AS AU, APUserPrivileges AS AP"
            ." WHERE AP.Privilege = '".addslashes($Privilege)."'"
            ." AND AU.UserId = AP.UserId";
}
else
{
    $Query = "SELECT DISTINCT UserId FROM APUsers";
}
$DB->Query($Query.$SortClause);
$PrivUserIds = $DB->FetchColumn("UserId");

# load IDs of users that meet specified search criteria
if (GetFormValue("F_Field") && GetFormValue("F_Condition")
        && strlen(GetFormValue("F_SearchText")))
{
    $ConditionMap = array(
            "contains" => "contains",
            "equals" => "=",
            "is before" => "<",
            "is after" => ">",
            );
    $Condition = $ConditionMap[GetFormValue("F_Condition")];
    $SearchText = GetFormValue("F_SearchText");
    if ($Condition == "contains")
    {
        $Target = "LIKE '%".addslashes($SearchText)."%'";
    }
    else
    {
        $Target = $Condition." '".addslashes($SearchText)."'";
    }
    if (GetFormValue("F_Field") == "ALL")
    {
        $AllFields = array(
                "UserName",
                "EMail",
                "RealName",
                "AddressLineOne",
                "AddressLineTwo",
                "State",
                "ZipCode",
                "Country",
                "LastLoginDate",
                "CreationDate",
                );
        foreach ($AllFields as $Field)
        {
            if (($Condition == "contains") && preg_match("/Date/", $Field))
            {
                $Field = "DATE_FORMAT(".$Field.", '%M %D %Y %l:%i%p')";
            }
            if (isset($WhereClause))
            {
                $WhereClause .= " OR ".$Field." ".$Target;
            }
            else
            {
                $WhereClause = " ".$Field." ".$Target;
            }
        }
    }
    elseif (GetFormValue("F_Field") == "Address")
    {
        $WhereClause = " AddressLineOne ".$Target." OR AddressLineTwo ".$Target;
    }
    elseif ((GetFormValue("F_Field") == "LastLoginDate")
            || (GetFormValue("F_Field") == "CreationDate"))
    {
        if ($Condition == "contains")
        {
            $WhereClause = "DATE_FORMAT(`".addslashes(GetFormValue("F_Field"))
                    ."`, '%M %D %Y %l:%i%p') ".$Target;
        }
        else
        {
            $SearchDate = new Date($SearchText);
            if (strlen($SearchDate->Formatted()))
            {
                $WhereClause = $SearchDate->SqlCondition(
                        GetFormValue("F_Field"), NULL, $Condition);
            }
            else
            {
                $WhereClause = "1 = 0";
            }
        }
    }
    else
    {
        $WhereClause = "`".addslashes(GetFormValue("F_Field"))."` ".$Target;
    }
    $DB->Query("SELECT UserId FROM APUsers WHERE ".$WhereClause.$SortClause);
    $SearchUserIds = $DB->FetchColumn("UserId");
}
else
{
    $SearchUserIds = $PrivUserIds;
}

# combine user ID lists to those that met all criteria
$UserIds = array_intersect($PrivUserIds, $SearchUserIds);

# calculate user ID list checksum to use to know when to reset paging
$G_UserIdChecksum = md5(serialize($UserIds));
if ($G_UserIdChecksum != GetFormValue("F_UserIdChecksum")) {  $G_StartingIndex = 0;  }

# pare list of user IDs down to segment to be displayed
$G_TotalItems = count($UserIds);
$G_ItemsPerPage = 25;
$UserIds = array_slice($UserIds, $G_StartingIndex, $G_ItemsPerPage);

# load users
$G_Users = array();
foreach ($UserIds as $Id)
{
    $G_Users[$Id] = new CWUser($Id);
}

# if ConfirmRemoveUser page was accessed previously but then user clicked
#       elseswhere instead of continuing the removal, these won't be cleared
foreach (array("UserRemoveArray", "OkayToRemoveUsers") as $Val)
{
    if (isset($_SESSION[$Val]))
    {
        unset($_SESSION[$Val]);
    }
}
