<?PHP
#
#   FILE:  TrackUserComments.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Track User Comments");

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Print link for previous user comment.
*/
function PrintPrevUserCommentLink()
{
    if (isset($_GET["UserCommentOffset"]))
    {
        $UserCommentOffset = $_GET["UserCommentOffset"];
    }
    else
    {
        $UserCommentOffset = 0;
    }

    $NumUserComments = $GLOBALS["G_SysConfig"]->NumAnnounceOnHomePage();
    $Offset = $UserCommentOffset + $NumUserComments;

    print "index.php?P=TrackUserComments&amp;UserCommentOffset=".$Offset;
}

/**
* Print link for next user comment.
*/
function PrintNextUserCommentLink()
{
    if (isset($_GET["UserCommentOffset"]))
    {
        $UserCommentOffset = $_GET["UserCommentOffset"];
    }
    else
    {
        $UserCommentOffset = 0;
    }

    $NumUserComments = $GLOBALS["G_SysConfig"]->NumAnnounceOnHomePage();
    $Offset = $UserCommentOffset - $NumUserComments;

    print "index.php?P=TrackUserComments&amp;UserCommentOffset=".$Offset;
}

/**
* Check if next user comments are available.
* @return TRUE if they are, FALSE otherwise.
*/
function NextUserCommentsAvailable()
{
    if (isset($_GET["UserCommentOffset"]))
    {
        $UserCommentOffset = $_GET["UserCommentOffset"];
    }
    else
    {
        $UserCommentOffset = 0;
    }

    $NumUserComments = $GLOBALS["G_SysConfig"]->NumAnnounceOnHomePage();
    return ($UserCommentOffset >= $NumUserComments) ? TRUE : FALSE;
}

/**
* Check if previous user comments are available.
* @return TRUE if they are, FALSE otherwise.
*/
function PreviousUserCommentsAvailable()
{
    global $MoreUserComments;
    return $MoreUserComments;
}

/**
* Print rows of user comments.
*/
function PrintUserCommentsTableRows()
{
    global $MoreUserComments;

    if (isset($_GET["UserCommentOffset"]))
    {
        $UserCommentOffset = $_GET["UserCommentOffset"];
    }
    else
    {
        $UserCommentOffset = 0;
    }

    # if function to supply announcement DB query is available
    if (function_exists("SupplyUserCommentDisplayQuery"))
    {
        # obtain query from function
        $DisplayQuery = SupplyUserCommentDisplayQuery(
                $MaxNumberOfDaysToGoBackForUserComments, 10);
    }
    else
    {
        # use default query
        $DisplayQuery = "SELECT * FROM Messages "
                ."WHERE ParentId > 0 "
                ."AND ParentType = 2 "
                ."AND ParentId IN "
                ."(SELECT ResourceId From Resources)"
                ."ORDER BY DatePosted DESC "
                ."LIMIT ${UserCommentOffset}, "
                ."999999999";
    }

    # query database for appropriate announcements
    $UserCommentDB = new Database();
    $UserCommentDB->Query($DisplayQuery);

    # determine number of announcements to display
    $MaxNumberOfUserCommentsToDisplay=min(10,
        $UserCommentDB->NumRowsSelected());

    # determine if previous link should be displayed or not
    $MoreUserComments = ($UserCommentDB->NumRowsSelected() <=
            $MaxNumberOfUserCommentsToDisplay) ? FALSE : TRUE;

    # if announcements found
    if ($UserCommentDB->NumRowsSelected() > 0)
    {
        $Index = 0;
        # for each announcement
        while ($Index++ < $MaxNumberOfUserCommentsToDisplay)
        {
            $UserComment = $UserCommentDB->FetchRow();

            $MessageId = $UserComment["MessageId"];
            $ResourceId = $UserComment["ParentId"];

            $Message = new Message($MessageId);
            $Resource = new Resource($ResourceId);

            $EditLink = "index.php?P=AddResourceComment"
                    ."&amp;ResourceId=".$ResourceId
                    ."&amp;MessageId=".$MessageId;
            $DeleteLink = "index.php?P=AddResourceComment"
                    ."&amp;ResourceId=".$ResourceId
                    ."&amp;MessageId=".$MessageId;
            $SpamLink = $GLOBALS["G_User"]->HasPriv(PRIV_FORUMADMIN, PRIV_USERADMIN) ?
                    "index.php?P=CleanSpam"
                    ."&amp;PI=".$UserComment["PosterId"]
                    ."&amp;RI=-1" :
                    "";

            # print comment
            PrintForumMessage(
                $Message, TRUE, $EditLink, $DeleteLink, NULL, TRUE, $SpamLink);
        }
    }
    else
    {
        # print row with "no announcements" notice
        PrintNoUserCommentsMessage();
    }
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $MoreUserComments;

if (!CheckAuthorization(PRIV_USERADMIN, PRIV_SYSADMIN))
{
    return;
}
