<?PHP
#
#   FILE:  RegisterPortalComplete.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2004-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

PageTitle("Registration Complete");

# destination for registration info e-mail
$RegInfoRecipient = "register@scout.wisc.edu";


# ----- EXPORTED FUNCTIONS ---------------------------------------------------

# ----- LOCAL FUNCTIONS ------------------------------------------------------

/**
* Generate content for registration email.
* @param array $UserEnteredVals Values provided by user.
* @return string XML registration data.
*/
function GetRegistrationMessageContent($UserEnteredVals)
{
    global $G_SysConfig;
    global $SPT_SoftwareVersionToDisplay;

    # create XML stream to use in generating content
    $XS = new XMLStream();
    $SchemaInfo = array(
        "xmlns" => "http://scout.wisc.edu/XML/register_v1.0/",
        "xmlns:xsi" => "http://www.w3.org/2001/XMLSchema-instance",
        "xsi:schemaLocation" => "http://scout.wisc.edu/XML/register_v1.0/ "
                ."http://scout.wisc.edu/XML/schemas/register_v1.0.xsd",
        "schemaVersion" => "1.0",
        );
    $XS->OpenElement("registration", $SchemaInfo);

    # retrieve and add general site info
    $XS->AddElement("software", "CWIS ".$SPT_SoftwareVersionToDisplay);
    if ($G_SysConfig->PortalName())
    {
        $XS->AddElement("sitename", $G_SysConfig->PortalName());
    }
    $XS->AddElement("siteuri",
            $_SERVER["SERVER_NAME"].dirname($_SERVER["REQUEST_URI"]));
    if ($G_SysConfig->AdminEmail())
    {
        $XS->AddElement("adminemail", $G_SysConfig->AdminEmail());
    }
    if ($G_SysConfig->ContactName())
    {
        $XS->AddElement("contactname", $G_SysConfig->ContactName());
    }
    if ($G_SysConfig->ContactEmail())
    {
        $XS->AddElement("contactemail", $G_SysConfig->ContactEmail());
    }
    if ($G_SysConfig->Organization())
    {
        $XS->AddElement("organization", $G_SysConfig->Organization());
    }
    if ($G_SysConfig->OrganizationType())
    {
        $XS->AddElement("organizationtype", $G_SysConfig->OrganizationType());
    }
    if ($G_SysConfig->SiteType())
    {
        $XS->AddElement("sitetype", $G_SysConfig->SiteType());
    }
    $XS->AddElement("okaytolistsite", ($G_SysConfig->OkayToListSite() ?
            "TRUE" : "FALSE"));
    $XS->AddElement("registeringuser", $GLOBALS["G_User"]->Get("UserName"));

    # retrieve and add configuration settings
    $XS->OpenElement("configuration");
    if ($G_SysConfig->DefaultActiveUI())
    {
        $XS->AddElement("defaultui", $G_SysConfig->DefaultActiveUI());
    }
    if ($G_SysConfig->CurrentTheme())
    {
        $XS->AddElement("currenttheme", $G_SysConfig->CurrentTheme());
    }
    $XS->OpenElement("toggles");
    $XS->AddElement("forums",
            ($G_SysConfig->ForumsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("announcements",
            ($G_SysConfig->AnnouncementsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("multipleuis",
            ($G_SysConfig->AllowMultipleUIsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("ratings",
            ($G_SysConfig->ResourceRatingsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("comments",
            ($G_SysConfig->ResourceCommentsEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("searchupdate",
            ($G_SysConfig->SearchDBEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("recommenderupdate",
            ($G_SysConfig->RecommenderDBEnabled() ? "ENABLED" : "DISABLED"));
    $XS->AddElement("searchlogic", ($G_SysConfig->SearchTermsRequired() ? "AND" : "OR"));
    $XS->CloseElement();
    $XS->CloseElement();

    # retrieve and add resource DB info
    $XS->OpenElement("datastatistics");
    $RFactory = new ResourceFactory();
    $ResourceCount = $RFactory->GetItemCount();
    $XS->AddElement("resourcecount", $ResourceCount);
    $ReleasedResourceCount = count(
        $RFactory->FilterNonViewableResources(
            $RFactory->GetItemIds(), CWUser::GetAnonymousUser()));
    $XS->AddElement("releasedresourcecount", $ReleasedResourceCount);
    $RatedResourceCount = $RFactory->GetRatedResourceCount();
    $XS->AddElement("ratingcount", $RatedResourceCount);

    $ClassFactory = new ClassificationFactory();
    $ClassCount = $ClassFactory->GetItemCount();
    $XS->AddElement("classificationcount", $ClassCount);

    $SampleCount = $RFactory->GetItemCount(
            "INSTR(Description, '[--SAMPLE RECORD--]') > 0");
    $XS->AddElement("sampleresourcecount", $SampleCount);

    $SearchEngine = new SPTSearchEngine();
    $TermCount = $SearchEngine->SearchTermCount();
    $XS->AddElement("searchtermcount", $TermCount);
    $XS->CloseElement();

    # retrieve and add operating environment info
    $XS->OpenElement("environment");
    $XS->AddElement("httpserver", $_SERVER["SERVER_SOFTWARE"]);
    $PhpInfo = GetPhpInfo();
    $XS->AddElement("osstamp", $PhpInfo[""]["System"][0]);
    # (PHP configuration)
    $XS->OpenElement("phpconfig");
    $XS->AddElement("version", phpversion());
    $Settings = array(
            "safe_mode",
            "register_globals",
            "max_execution_time",
            "memory_limit",
            "post_max_size",
            "file_uploads",
            "upload_max_filesize",
            );
    foreach ($Settings as $Setting)
    {
        $Value = ini_get($Setting);
        if (!strlen($Value))
        {
            $Value = "Off";
        }
        else if ($Value == "1")
        {
            $Value = "On";
        }
        $ElementName = str_replace("_", "", $Setting);
        $XS->AddElement($ElementName, $Value);
    }
    $Val = (isset($PhpInfo["gd"]["GD Version"][0])) ?
            $PhpInfo["gd"]["GD Version"][0] : "unavailable";
    $XS->AddElement("gdversion", $Val);
    $Val = (isset($PhpInfo["gd"]["PNG Support"][0])) ?
            $PhpInfo["gd"]["PNG Support"][0] : "unavailable";
    $XS->AddElement("gdpngsupport", $Val);
    $Val = (isset($PhpInfo["gd"]["JPG Support"][0])) ?
            $PhpInfo["gd"]["JPG Support"][0] : "unavailable";
    $XS->AddElement("gdjpgsupport", $Val);
    $Val = (isset($PhpInfo["gd"]["GIF Support"][0])) ?
            $PhpInfo["gd"]["GIF Support"][0] : "unavailable";
    $XS->AddElement("gdgifsupport", $Val);
    $XS->CloseElement();
    # (MySQL configuration)
    $DB = new Database();
    $XS->OpenElement("mysqlconfig");
    $XS->AddElement("clientversion", $DB->GetClientVersion());
    $XS->AddElement("serverversion", $DB->GetServerVersion());
    $XS->AddElement("connectiontype", $DB->GetHostInfo());
    $XS->CloseElement();
    $XS->CloseElement();

    # add user comments (if any)
    if (strlen($UserEnteredVals["F_Comments"]) > 0)
    {
        $XS->AddElement("comments", $UserEnteredVals["F_Comments"]);
    }

    # retrieve XML from XML stream and return to caller
    $XS->CloseElement();
    return $XS->GetContent();
}

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $SPT_SoftwareVersionToDisplay;
global $G_SysConfig;

# save any user-entered registration values
if (isset($_POST["F_ContactName"]) && strlen($_POST["F_ContactName"]))
{
    $G_SysConfig->ContactName($_POST["F_ContactName"]);
}
if (isset($_POST["F_ContactEmail"]) && strlen($_POST["F_ContactEmail"]))
{
    $G_SysConfig->ContactEmail($_POST["F_ContactEmail"]);
}
if (isset($_POST["F_Organization"]) && strlen($_POST["F_Organization"]))
{
    $G_SysConfig->Organization($_POST["F_Organization"]);
}
if (isset($_POST["F_OrganizationType"]) &&
    strlen($_POST["F_OrganizationType"]))
{
    $G_SysConfig->OrganizationType($_POST["F_OrganizationType"]);
}
if (isset($_POST["F_SiteType"]) &&strlen($_POST["F_SiteType"]))
{
    $G_SysConfig->SiteType($_POST["F_SiteType"]);
}
$G_SysConfig->OkayToListSite(isset($_POST["F_OkayToListSite"]) ? 1 : 0);

# generate XML containing registration info
$MsgContent = GetRegistrationMessageContent($_POST);

# e-mail registration info to Scout
$MsgSubject = "CWIS Registration";
if ($G_SysConfig->PortalName() != "Online Resource Portal")
{
    $MsgSubject .= " (".$G_SysConfig->PortalName().")";
}
else
{
    $MsgSubject .= " (".$_SERVER["SERVER_NAME"].")";
}
$Msg = new Email();
$Msg->To($RegInfoRecipient);
$Msg->From($G_SysConfig->AdminEmail());
$Msg->Subject($MsgSubject);
$Msg->Body($MsgContent);
$Msg->Send();

# save registration date
$G_SysConfig->LastRegisteredOn(date("Y-m-d H:i:s"));
