<?PHP
#
#   FILE:  EditResource.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# if resource ID was supplied
$G_AddingNewResource = FALSE;
if (isset($_GET["ID"]) )
{
    # if this is a view request (from editing complete form)
    if (isset($_POST["Submit"]) && ($_POST["Submit"] == "View"))
    {
        # go to full record page
        $Resource = new Resource($_GET["ID"]);
        $H_Schema = new MetadataSchema($Resource->SchemaId());
        $ViewUrl = $H_Schema->ViewPage();
        if (!strlen($ViewUrl)) {  $ViewUrl = "index.php?P=FullRecord&ID=\$ID";  }
        $ViewUrl = preg_replace("%\\\$ID%", intval($_GET["ID"]), $ViewUrl);

        # redirect to the clean URL whenever possible
        if ($AF->HtaccessSupport())
        {
            $ViewUrl = ApplicationFramework::BaseUrl().$AF->GetCleanUrlForPath($ViewUrl);
        }

        $AF->SetJumpToPage($ViewUrl);
    }
    else
    {
        # if creating a new resource was requested
        $ResourceId = $_GET["ID"];
        if ($ResourceId == "NEW")
        {
            # retrieve schema for new resource
            $SchemaId = isset($_GET["SC"]) ? $_GET["SC"]
                    : MetadataSchema::SCHEMAID_DEFAULT;
            $H_Schema = new MetadataSchema($SchemaId);

            # bail out if user is not authorized to create new resources
            if (!$H_Schema->UserCanAuthor($GLOBALS["G_User"]))
            {
                CheckAuthorization(-1);
                return;
            }

            # create new resource
            $G_Resource = Resource::Create($SchemaId);
        }
        else
        {
            # if resource ID was valid
            if (Resource::ItemExists($ResourceId))
            {
                # load resource to be edited
                $G_Resource = new Resource($ResourceId);
            }
        }

        # if resource failed to load
        if (!isset($G_Resource))
        {
            # bail out if user does not have appropriate privileges
            if (!CheckAuthorization(PRIV_RESOURCEADMIN,
                    PRIV_MYRESOURCEADMIN, PRIV_RELEASEADMIN)) {  return;  }

            # set flag to indicate error message needed
            $G_ResourceNotFound = TRUE;
        }
        else
        {
            # bail out if user is not authorized to modify this resource
            if (!$G_Resource->UserCanModify($GLOBALS["G_User"]))
            {
                CheckAuthorization(-1);
                return;
            }

            # set flag to indicate if we are adding a new resource
            $G_AddingNewResource = $G_Resource->IsTempResource();

            # set page title to indicate adding or editing
            PageTitle($G_AddingNewResource ? "Add Resource" : "Edit Resource");

            # load metadata fields
            $H_Schema = new MetadataSchema($G_Resource->SchemaId());
            $G_Fields = $H_Schema->GetFields(NULL, MetadataSchema::MDFORDER_EDITING);

            # set page title to indicate adding or editing
            $ResourceName = $H_Schema->ResourceName();
            PageTitle(($G_AddingNewResource ? "Add" : "Edit")." ".$ResourceName);

            $G_Resource->UpdateAutoupdateFields(
                MetadataField::UPDATEMETHOD_ONRECORDEDIT,
                $GLOBALS["G_User"]);

        }
    }
}
else
{
    # bail out if user does not have appropriate privileges
    if (!CheckAuthorization(PRIV_RESOURCEADMIN,
            PRIV_MYRESOURCEADMIN, PRIV_RELEASEADMIN)) {  return;  }

    # set flag to indicate error message needed
    $G_NoResourceIdFound = TRUE;
}

# grab error info if present
$G_ErrorCode = isset($_GET["ER"]) ? $_GET["ER"] : NULL;
$G_ErrorFieldIds = (isset($_GET["EF"]) && strlen($_GET["EF"]))
        ? explode("-", $_GET["EF"]) : array();
$G_ErrorInfoOne = isset($_GET["E1"]) ? $_GET["E1"] : NULL;
$G_ErrorInfoTwo = isset($_GET["E2"]) ? $_GET["E2"] : NULL;
