<?PHP
#
#   FILE:  AddQualifier.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2003-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

# ----- EXPORTED FUNCTIONS ---------------------------------------------------

/**
* Display qualifier lists for editing.
*/
function DisplayQualifiers()
{
    global $QualifierFactory;
    global $QualifierName;
    global $QualifierNamespace;
    global $QualifierUrl;
    global $QualifierId;
    global $Index;

    if ($QualifierFactory->GetItemCount())
    {
        $Index = 0;
        $QualifierList = $QualifierFactory->GetItemNames();
        foreach ($QualifierList as $QualifierId => $QualifierName)
        {
            $Qualifier = new Qualifier($QualifierId);
            $QualifierNamespace = $Qualifier->NSpace();
            $QualifierUrl = $Qualifier->Url();
            DisplayQualifierSelection();
            $Index++;
        }
    }
}

# ----- LOCAL FUNCTIONS ------------------------------------------------------

# ----- MAIN -----------------------------------------------------------------

# non-standard global variables
global $Index;
global $QualifierFactory;
global $QualifierId;
global $QualifierName;
global $QualifierNamespace;
global $QualifierUrl;

$QualifierFactory = new QualifierFactory();

if (!CheckAuthorization(PRIV_SYSADMIN, PRIV_COLLECTIONADMIN))
{
    return;
}

if (isset($_SESSION["ErrorMessages"]))
{
    $H_ErrorMessages = $_SESSION["ErrorMessages"];
    unset($_SESSION["ErrorMessages"]);
}

PageTitle("Add/Edit Qualifiers");

?>
