<?PHP
class File_Test extends PHPUnit\Framework\TestCase
{
	/**
	* Verify that files can be created and return the proper error/success codes.
	* covers Create()
	*/
	function testCreate()
	{
		$File = File::Create("invalid/path", "testFile");
		$this->assertSame(File::FILESTAT_DOESNOTEXIST, $File);

		$File = File::Create("objects/tests/files/ZeroLengthFile.txt");
		$this->assertSame(File::FILESTAT_ZEROLENGTH, $File);

		$File = File::Create("objects/tests/files/ValidFile.txt");
		$this->assertInstanceOf('File', $File);

		$StoredFilePath = $File->GetNameOfStoredFile();

		$this->assertSame(file_get_contents("objects/tests/files/ValidFile.txt"),
			file_get_contents($StoredFilePath));

		$File->Destroy();
		$this->assertFileNotExists($StoredFilePath);
	}

	function testCreateCopy()
	{
		$File = File::Create("objects/tests/files/ValidFile.txt");
		$Copy = $File->CreateCopy();
		$this->assertSame($Copy->Name(), $File->Name());
		$this->assertSame(file_get_contents($Copy->GetNameOfStoredFile()),
			file_get_contents("objects/tests/files/ValidFile.txt"));
		$Copy->Destroy();
		$File->Destroy();
	}

	function testGetLength()
	{
		$File = File::Create("objects/tests/files/ValidFile.txt");
		$this->assertSame($File->GetLength(), '21');
		$File->Destroy();
	}

	function testGetType()
	{
		$File = File::Create("objects/tests/files/ValidFile.txt");
		$this->assertSame($File->GetType(), 'text/plain');
		$File->Destroy();
	}

	function testComment()
	{
		$File = File::Create("objects/tests/files/ValidFile.txt");
		$File->Comment("abc123");
		$this->assertSame($File->Comment(), "abc123");
		$File->Destroy();
	}

	function testFieldId()
	{
		$File = File::Create("objects/tests/files/ValidFile.txt");
		$File->FieldId(PHP_INT_MAX);
		$this->assertSame($File->FieldId(), PHP_INT_MAX);
		$File->Destroy();
	}

	function testResourceId()
	{
		$File = File::Create("objects/tests/files/ValidFile.txt");
		$File->ResourceId(PHP_INT_MAX);
		$this->assertSame($File->ResourceId(), PHP_INT_MAX);
		$File->Destroy();
	}

	function testGetMimeType()
	{
		$File = File::Create("objects/tests/files/ValidFile.txt");
		$this->assertSame($File->GetMimeType(), "text/plain");
		$File->Destroy();
	}

	function testGetLink()
	{
		$File = File::Create("objects/tests/files/ValidFile.txt");

		$GLOBALS["G_PluginManager"]->PluginEnabled("CleanURLs", FALSE);
		$this->assertSame($File->GetLink(), "index.php?P=DownloadFile&Id=".$File->Id());

		$GLOBALS["G_PluginManager"]->PluginEnabled("CleanURLs", TRUE);
		$this->assertSame($File->GetLink(), "downloads/".$File->Id()."/ValidFile.txt");

		$File->Destroy();
	}

	function testGetStorageDirectory()
	{
		$File = File::Create("objects/tests/files/ValidFile.txt");
		$this->assertSame($File->GetStorageDirectory(), "local/data/files");
		$File->Destroy();
	}
}