<?PHP
#
#   FILE:  Qualifier.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2012-2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

class Qualifier extends Item
{

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
    * Initialize a new qualifier.
    * @return A new qualifier just created to set its parameters.
    */
    public static function Create()
    {
        $DB = new Database();

        # determine next qualifier ID
        $HighestId = $DB->Query("
            SELECT QualifierId FROM Qualifiers
            ORDER BY QualifierId DESC
            LIMIT 1", "QualifierId");
        $Id = $HighestId > 0 ? $HighestId + 1 : 1;

        # add record to database with that ID
        $DB->Query("
            INSERT INTO Qualifiers
            SET QualifierId = ".addslashes($Id));

        # use that ID to create new Qualifer object
        $Qualifer = new Qualifier($Id);
        return $Qualifer;
    }

    /**
     * Get or set the qualifier namespace.
     * @param string $NewValue Optional new qualfier namespace.
     * @return string The current qualifier namespace.
     */
    public function NSpace($NewValue=DB_NOVALUE)
    {
        return $this->UpdateValue("QualifierNamespace", $NewValue);
    }

    /**
     * Get or set the qualifier URL.
     * @param string $NewValue Optional new qualifier URL.
     * @return string The current qualifier URL.
     */
    public function Url($NewValue=DB_NOVALUE)
    {
        return $this->UpdateValue("QualifierUrl", $NewValue);
    }
}
