<?PHP
#
#   FILE:  Classification.php
#
#   Part of the Collection Workflow Integration System (CWIS)
#   Copyright 2013 Edward Almasy and Internet Scout Research Group
#   http://scout.wisc.edu/cwis/
#

/**
* Generator for checkbox input fields
* \nosubgrouping
*/
class CheckboxFormField extends FormField
{

    # ---- PUBLIC INTERFACE --------------------------------------------------

    /**
    * Object constructor.
    * @param string $Name Internal name of the checkbox field, used as the id= in HTML
    * @param string $Label Display name of the checkbox field, showed to the user
    */
    public function __construct($Name, $Label)
    {
        parent::__construct($Name, FALSE, $Label, NULL, NULL);
    }

    /**
    * Generate HTML for the int field and label.
    * @param bool $DisplayErrorIndicator Setting TRUE will generate
    *       html error indicators. (OPTIONAL)
    */
    public function PrintField($DisplayErrorIndicator = FALSE)
    {
        $this->PrintInput($DisplayErrorIndicator);
        $this->PrintLabel($DisplayErrorIndicator);
    }

    /**
    * Generate HTML just for the input field.
    * @param bool $DisplayErrorIndicator Setting TRUE will generate html
    *       error indicators (OPTIONAL)
    */
    public function PrintInput($DisplayErrorIndicator = FALSE)
    {
        print("<input type=\"checkbox\""
                ." name=\"".$this->MyName."\""
                ." id=\"".$this->MyName."\""
                .($this->MyValue ? " checked" : "")
                .">\n");
    }


    # ---- PRIVATE INTERFACE -------------------------------------------------
}

