<?PHP

$GLOBALS["G_ErrMsgs"] = SiteUpgrade392_PerformUpgrade();

/**
* Perform all of the site upgrades for 3.9.2.
* @return Returns NULL on success and an eror message if an error occurs.
*/
function SiteUpgrade392_PerformUpgrade()
{
    try
    {
        Msg(1, "Setting standard metadata field mappings...");
        SiteUpgrade392_SetStandardFieldMappings();

        Msg(1, "Removing obsolete 'Checking Resource' privset entry...");
        SiteUpgrade392_RemoveCheckingResource();

        Msg(1, "Adding 'Creation Date' field to User schema...");
        SiteUpgrade392_UpdateUserSchema();
    }
    catch (Exception $Exception)
    {
        return array($Exception->getMessage(),
                "Exception Trace:<br/><pre>"
                        .$Exception->getTraceAsString()."</pre>");
    }
}

/**
* Set standard metadata field mappings for existing schemas.
*/
function SiteUpgrade392_SetStandardFieldMappings()
{
    $DB = new Database();
    $StandardFieldNameSets = array(
            MetadataSchema::SCHEMAID_DEFAULT => array(
                    "Title" => "Title",
                    "Description" => "Description",
                    "Url" => "Url",
                    "Screenshot" => "Screenshot",
                    "File" => FALSE
                    ),
            "Blog" => array(
                    "Title" => "Title",
                    ),
            "Events" => array(
                    "Title" => "Title",
                    "Description" => "Description",
                    "Url" => "Url",
                    ),
            "Pages" => array(
                    "Title" => "Title",
                    "Description" => "Summary",
                    "File" => "Files",
                    ),
            );
    foreach ($StandardFieldNameSets as $SchemaId => $StandardFieldNames)
    {
        if (!is_numeric($SchemaId))
        {
            $SchemaId = MetadataSchema::GetSchemaIdForName($SchemaId);
        }

        if (MetadataSchema::SchemaExistsWithId($SchemaId))
        {
            $Schema = new MetadataSchema($SchemaId);
            foreach ($StandardFieldNames as $StandardName => $FieldName)
            {
                $FieldId = -1;
                if ($SchemaId == MetadataSchema::SCHEMAID_DEFAULT)
                {
                    $SysConfigField = $StandardName."Field";
                    if ($DB->FieldExists("SystemConfiguration", $SysConfigField))
                    {
                        $FieldId = $DB->Query("SELECT ".$SysConfigField
                                ." FROM SystemConfiguration", $SysConfigField);
                        $DB->Query("ALTER TABLE SystemConfiguration"
                                ." DROP COLUMN ".$SysConfigField);
                    }
                }
                if ($FieldId < 0)
                {
                    $FieldId = $Schema->GetFieldIdByName($FieldName);
                }
                if ($FieldId !== FALSE)
                {
                    $Schema->StdNameToFieldMapping($StandardName, $FieldId);
                }
            }
        }
    }
}

/**
* Remove 'Checking Resource' condition from privsets.
*/
function SiteUpgrade392_RemoveCheckingResource()
{
    # list of priv types we'll be checking
    $PrivTypes = array(
        "AuthoringPrivileges",
        "EditingPrivileges",
        "ViewingPrivileges");

    # iterate over each schema
    foreach (MetadataSchema::GetAllSchemas() as $Schema)
    {
        $Schema = new MetadataSchema(MetadataSchema::SCHEMAID_DEFAULT);

        # iterate over priv types
        foreach ($PrivTypes as $PrivType)
        {
            $NewPrivs = $Schema->$PrivType();
            foreach (array(TRUE, FALSE) as $Val)
            {
                $NewPrivs->RemoveCondition(
                    -1, $Val, "==", TRUE);
            }
            $Schema->$PrivType($NewPrivs);
        }


        # iterate over all field privs in this schema
        foreach ($Schema->GetFields() as $Field)
        {

            # iterate over priv types
            foreach ($PrivTypes as $PrivType)
            {
                $NewPrivs = $Field->$PrivType();
                foreach (array(TRUE, FALSE) as $Val)
                {
                    $NewPrivs->RemoveCondition(
                        -1, $Val, "==", TRUE);
                }
                $Field->$PrivType($NewPrivs);
            }
        }
    }
}

/**
* Add and populate the 'Creation Date' user schema field.
*/
function SiteUpgrade392_UpdateUserSchema()
{
    $Schema = new MetadataSchema(MetadataSchema::SCHEMAID_USER);

    # if the User schema lacks a CreationDate field
    if ($Schema->GetFieldByName("CreationDate") === NULL)
    {
        # Re-run the XML to create it
        $Schema->AddFieldsFromXmlFile(
            "install/MetadataSchema--User.xml");
    }

    # propagate any existing data into the CreationDate field
    # (this is done outside the if() because a previous
    # AddFieldsFromXmlFile() may have added the field earlier in the
    # upgrade process)

    # pull out the UserId and CreationDate fields
    $UidField = $Schema->GetField("UserId");
    $CreationDateField = $Schema->GetField("CreationDate");

    # extract CreationDate data from the APUsers table
    $DB = new Database();
    $DB->Query(
        "SELECT R.ResourceId AS ResourceId, "
        ."    U.CreationDate AS CreationDate "
        ."FROM APUsers U, Resources R, ResourceUserInts RU "
        ."WHERE RU.ResourceId = R.ResourceId "
        ."  AND RU.UserId = U.UserId "
        ."  AND RU.FieldId = ".intval($UidField->Id()) );
    $Rows = $DB->FetchRows();

    # populate CreationDate in the Resources table
    foreach ($Rows as $Row)
    {
        $DB->Query(
            "UPDATE Resources "
            ."SET ".$CreationDateField->DBFieldName()." = "
            ."'".addslashes($Row["CreationDate"])."' "
            ."WHERE ResourceId=".intval($Row["ResourceId"]));
    }
}