
----- SCOUTLIB UPDATES ------------------------------------------------------

-- new application framework column for storing base URL path
ALTER TABLE ApplicationFrameworkSettings ADD COLUMN BasePath TEXT;
ALTER TABLE ApplicationFrameworkSettings ADD COLUMN BasePathCheck TEXT;

-- increase plugin config data storage
ALTER TABLE PluginInfo MODIFY COLUMN Cfg MEDIUMTEXT;


----- CWIS UPDATES ----------------------------------------------------------

-- new column used for requiring an e-mail address when submitting feedback
ALTER TABLE SystemConfiguration ADD COLUMN RequireEmailWithFeedback INT DEFAULT 0;

-- new column used for enabling incremental keyword searching
ALTER TABLE SystemConfiguration ADD COLUMN IncrementalKeywordSearchEnabled INT DEFAULT 1;

-- new column used for selecting a saved search mail template
ALTER TABLE SystemConfiguration ADD COLUMN SavedSearchMailTemplate INT DEFAULT -1;

-- new column used for determining whether minimized JavaScript files should be use
ALTER TABLE SystemConfiguration ADD COLUMN UseMinimizedJavascript INT DEFAULT 0;

-- new schema ID column for supporting multiple metadata schemas
ALTER TABLE MetadataFields ADD COLUMN SchemaId INT NOT NULL DEFAULT 0;
ALTER TABLE Resources ADD COLUMN SchemaId INT NOT NULL DEFAULT 0;
ALTER TABLE Resources ADD INDEX SchemaId (SchemaId);

-- add the "Reference" field type for metadata fields
ALTER TABLE MetadataFields CHANGE FieldType
    FieldType ENUM("Text", "Number", "Date", "TimeStamp", "Paragraph", "Flag",
          "Tree", "ControlledName", "Option", "User", "Still Image", "File",
          "Url", "Point", "Reference");
-- references/links between source resources to destination resources
CREATE TABLE IF NOT EXISTS ReferenceInts (
    FieldId       INT,
    SrcResourceId INT,
    DstResourceId INT,
    INDEX         (FieldId, SrcResourceId)
);

-- resource metadata field orders
CREATE TABLE IF NOT EXISTS MetadataFieldOrders (
    SchemaId                  INT NOT NULL,
    OrderId                   INT NOT NULL,
    OrderName                 TEXT
);

-- metadata schemas (with idempotent insert of default schemas)
CREATE TABLE IF NOT EXISTS MetadataSchemas (
    SchemaId                INT NOT NULL,
    Name                    TEXT,
    AuthoringPrivileges     BLOB,
    EditingPrivileges       BLOB,
    ViewingPrivileges       BLOB,
    ViewPage                TEXT,
    PRIMARY KEY             (SchemaId),
    INDEX                   (SchemaId)
);
-- (following ALTER statements are redundant, and should be removed before release)
ALTER TABLE MetadataSchemas ADD COLUMN AuthoringPrivileges BLOB;
ALTER TABLE MetadataSchemas ADD COLUMN EditingPrivileges BLOB;
ALTER TABLE MetadataSchemas ADD COLUMN ViewingPrivileges BLOB;
ALTER TABLE MetadataSchemas MODIFY COLUMN SchemaId INT NOT NULL;
ALTER TABLE MetadataSchemas ADD PRIMARY KEY(SchemaId);
-- (END of redundant statements)
INSERT IGNORE INTO MetadataSchemas (SchemaId, Name, ViewPage,
                AuthoringPrivileges, EditingPrivileges, ViewingPrivileges)
        VALUES (0, 'Default', 'index.php?P=FullRecord&ID=$ID',
                'a:1:{s:10:"Privileges";a:1:{i:0;i:3;}}',
                'a:1:{s:10:"Privileges";a:3:{i:0;i:3;i:1;i:7;i:2;a:1:{s:6:"SUBSET";s:106:"a:1:{s:10:"Privileges";a:2:{i:0;i:12;i:1;a:3:{s:7:"FieldId";i:16;s:8:"Operator";s:2:"==";s:5:"Value";N;}}}";}}}',
                'a:1:{s:10:"Privileges";a:3:{i:0;a:3:{s:7:"FieldId";i:5;s:8:"Operator";s:2:"==";s:5:"Value";i:1;}i:1;i:3;i:2;a:1:{s:6:"SUBSET";s:106:"a:1:{s:10:"Privileges";a:2:{i:0;i:12;i:1;a:3:{s:7:"FieldId";i:16;s:8:"Operator";s:2:"==";s:5:"Value";N;}}}";}}}');
INSERT IGNORE INTO MetadataSchemas (SchemaId, Name, ViewPage,
                AuthoringPrivileges, EditingPrivileges, ViewingPrivileges)
        VALUES (1, 'User', 'index.php?P=UserList',
                'a:1:{s:10:"Privileges";a:1:{i:0;i:8;}}',
                'a:1:{s:10:"Privileges";a:1:{i:0;i:8;}}',
                'a:1:{s:10:"Privileges";a:1:{i:0;i:8;}}');
UPDATE MetadataSchemas SET SchemaId = 1 WHERE Name = 'User';

-- new privilege set support for metadata fields
ALTER TABLE MetadataFields ADD COLUMN AuthoringPrivileges BLOB;
ALTER TABLE MetadataFields ADD COLUMN EditingPrivileges BLOB;
ALTER TABLE MetadataFields ADD COLUMN ViewingPrivileges BLOB;
ALTER TABLE MetadataFields ADD COLUMN PreviewingPrivileges BLOB;

-- new columns used for the task priority level for the search and recommender
-- database update tasks
ALTER TABLE SystemConfiguration ADD COLUMN SearchEngineUpdatePriority INT DEFAULT 3;
ALTER TABLE SystemConfiguration ADD COLUMN RecommenderEngineUpdatePriority INT DEFAULT 3;

-- change default widths of Title, Alternate Title, Url, and Description fields
UPDATE MetadataFields SET TextFieldSize = 100
        WHERE (FieldName = 'Title' OR FieldName = 'Alternate Title' OR FieldName = 'Url')
        AND SchemaId = 0 AND TextFieldSize = 30;
UPDATE MetadataFields SET ParagraphCols = 76 WHERE FieldName = 'Description' AND ParagraphCols = 38;

-- add new thresholds for controlled name fields
ALTER TABLE MetadataFields ADD COLUMN OptionListThreshold INT NOT NULL DEFAULT 25;
ALTER TABLE MetadataFields ADD COLUMN AjaxThreshold INT NOT NULL DEFAULT 50;
