<?php
/**
 * @package TropedCourses
 */

/*
Plugin Name: Troped Theses
Plugin URI: 
Description: Plugin para el sitio de theses de troped
Version: 0.1
Author: Ricardo Cortes
Author URI: 
License: GLPv2 or later
License URI: 
*/
/*
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

/***** DEFINICIÓN DE VARIABLES *****/
$theses_url = "/theses/";
$plugin_url = plugin_dir_url( __FILE__ );
$theses_prefix = "theses-"; #$GLOBALS['theses_prefix']
/***** END DEFINICIÓN DE VARIABLES *****/

if ( ! defined( 'ABSPATH' ) ) {
	die;
}

add_action('init', 'ThesesStartSession', 1);
add_action('wp_logout', 'ThesesEndSession');
add_action('wp_login', 'ThesesEndSession');

function ThesesStartSession() {
    if(!session_id()) {
		session_name("AxisPHP");
        session_start();
    }
}

function ThesesEndSession() {
    session_destroy ();
}

/***** THESES *****/
function insert_theses_index($atts) {
	if ( file_exists(".".$GLOBALS['theses_url']."main-courses-wp.php") ) {
		include(".".$GLOBALS['theses_url']."main-courses-wp.php");
	}
}
add_shortcode('theses_index', 'insert_theses_index');
/***** END THESES *****/

/***** ADVANCED SEARCH *****/
function insert_theses_advanced_search_institution($atts) {
	if ( file_exists(".".$GLOBALS['theses_url']."advanced-wp.php") ) {
		$_GET['op']="Institution";
		include(".".$GLOBALS['theses_url']."advanced-wp.php");
	}
}
add_shortcode('theses_advanced_search_institution', 'insert_theses_advanced_search_institution');

function insert_theses_advanced_search_datestart($atts) {
	if ( file_exists(".".$GLOBALS['theses_url']."advanced-search-wp.php") ) {
		$_GET['op']="datestart";
		include(".".$GLOBALS['theses_url']."advanced-search-wp.php");
	}
}
add_shortcode('advanced_theses_search_datestart', 'insert_theses_advanced_search_datestart');

function insert_theses_advanced_search($atts) {
	if ( file_exists(".".$GLOBALS['theses_url']."advanced-search-wp.php") ) {
		include(".".$GLOBALS['theses_url']."advanced-search-wp.php");
	}
}
add_shortcode('theses_advanced_search', 'insert_theses_advanced_search');

function insert_theses_advanced($atts) {
	if ( file_exists(".".$GLOBALS['theses_url']."advanced-wp.php") ) {
		$search_filter = isset($atts['op']) ? $atts['op'] : "";
		$_GET['op'] = $search_filter;
		include(".".$GLOBALS['theses_url']."advanced-wp.php");
	}
}
add_shortcode('theses_advanced', 'insert_theses_advanced');
/***** END ADVANCED SEARCH *****/

/***** FULL RECORD *****/
function insert_theses_full_record($atts) {
	if ( file_exists(".".$GLOBALS['theses_url']."full-record-wp.php") ) {
		include(".".$GLOBALS['theses_url']."full-record-wp.php");
	}
}
add_shortcode('theses_full_record', 'insert_theses_full_record');

function insert_theses_full_record_resource($atts) {
	if ( file_exists(".".$GLOBALS['theses_url']."full-record-resource-wp.php") ) {
		include(".".$GLOBALS['theses_url']."full-record-resource-wp.php");
	}
}
add_shortcode('theses_full_record_resource', 'insert_theses_full_record_resource');
/***** END FULL RECORD *****/

/***** DOWNLOAD FILE *****/
function insert_theses_download_file($atts) {
	if ( file_exists(".".$GLOBALS['theses_url']."download-file-wp.php") ) {
		include(".".$GLOBALS['theses_url']."download-file-wp.php");
	}
}
add_shortcode('theses_download_file', 'insert_theses_download_file');
/***** END DOWNLOAD FILE *****/

/***** INCLUDE JAVASCRIPT *****/
#<script type="text/javascript" src="../wp-content/plugins/troped-courses/courses_scripts.js"></script>
function theses_custom_script() {
    wp_enqueue_script( 'my_theses_script', $GLOBALS['plugin_ur'] . 'theses_scripts.js', array('jquery'), '1.0.0', false );
}
add_action('admin_enqueue_scripts', 'theses_custom_script');
/***** END INCLUDE JAVASCRIPT *****/

/***** INCLUDE CSS STYLE *****/
#<style><?php require("courses_style.css");?</style>
function theses_custom_style() {
	wp_enqueue_style( 'style',  $GLOBALS['plugin_ur'] . "/theses_style.css");
}
add_action( 'admin_print_styles', 'theses_custom_style' );

function theses_styles() {
	wp_enqueue_style( 'style',  $theses_url . "SPTUI--CWIS/Themes/Theme--Droplets/SPT--Stylesheet.css");
}
#add_action( 'wp_enqueue_scripts', 'theses_styles' );
/***** END INCLUDE CSS STYLE *****/
/*
function Theses_Admin_Redirect($obj){
	$obj = "SPT--UserLogin-wp.php/?page=".home_url()."/courses/".$obj;
	#$obj = "SPT--UserLogin-wp.php/?page=".$obj;
	echo '<iframe id="iFrameCourses" src="../courses/'.$obj.'" frameborder="1" transparency="transparency" onload="autofitIframe(this);"></iframe>';
}
*/
/**** DDL INSTITUTIONS ****
function insert_ddl_institutions($atts) {
	$dbServerName = "localhost";
    $dbUsername = "demotrop_root";
    $dbPassword = "tr0p3d_2020";
    $dbName = "demotrop_courses";
    
    // create connection
    $conn = new wpdb ($dbServerName, $dbUsername, $dbPassword, $dbName);
    
    // check connection
    if ($conn->connect_error) {
        die("Conexión fallida: " . $conn->connect_error);
    }
    echo "Ehorabuena!!! Has conectado con la base de datos correctamente.";
}
add_shortcode('ddl_institution', 'insert_ddl_institutions');
**** END DDL INSTITUTIONS ****/

/********** Menu de administración de Troped **********
add_action( 'admin_menu', 'troped_admin_menu' );

function troped_admin_menu() {
	add_menu_page( 'Troped Administration Menu', 'Courses Administration', 'manage_options', 'Top-Menu-Troped-Admin', '', 'dashicons-admin-site', 6  );
	
	add_submenu_page( 'Top-Menu-Troped-Admin', 'Administration', 'Administration', 'manage_options', 'Top-Menu-Troped-Admin', 'Troped_Administration', 0 );
	add_submenu_page( 'Top-Menu-Troped-Admin', 'Preferences', 'Preferences', 'manage_options', 'Sub-Menu-Troped-Preferences', 'Troped_Preferences', 1 );
	add_submenu_page( 'Top-Menu-Troped-Admin', 'Metadata Tool', 'Metadata Tool', 'manage_options', 'Sub-Menu-Troped-MetadataTool', 'Troped_Metadata_Tool', 2 );
	add_submenu_page( 'Top-Menu-Troped-Admin', 'Edit User Account', 'Edit User Account', 'manage_options', 'Sub-Menu-Troped-Edit-User-Account', 'Troped_Edit_User_Account', 3 );
	add_submenu_page( 'Top-Menu-Troped-Admin', 'Metadata Tool Help', 'Metadata Tool Help', 'manage_options', 'Sub-Menu-Troped-Metadata-Tool-Help', 'Troped_Metadata_Tool_Help', 4 );
}

function Troped_Preferences(){
	Troped_Admin_Redirect("SPT--Preferences.php");
}

function Troped_Metadata_Tool(){
	Troped_Admin_Redirect("MetadataTool/SPT--MDHome.php");
}

function Troped_Administration(){
	Troped_Admin_Redirect("SPT--SysAdmin.php");
}

function Troped_Edit_User_Account(){
	Troped_Admin_Redirect("SPT--SelectEditUser.php");
}

function Troped_Metadata_Tool_Help(){
	Troped_Admin_Redirect("MetadataTool/SPT--MetadataHelp.php");
}


/********** Menu de administración de Recursos Troped **********
add_action( 'admin_menu', 'troped_resources_menu' );

function troped_resources_menu() {
	add_menu_page( 'Troped Resources Menu', 'Courses Resources', 'manage_options', 'Top-Menu-Troped-Resources', '', 'dashicons-admin-site', 7  );
	
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Resources', 'Resources', 'manage_options', 'Top-Menu-Troped-Resources', 'Troped_Resources', 0 );
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Add New Resource', 'Add New Resource', 'manage_options', 'Sub-Menu-Add-New-Resource', 'Troped_Add_New_Resource', 1 );
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Edit Resources', 'Edit Resources', 'manage_options', 'Sub-Menu-Edit-Resources', 'Troped_Edit_Resources', 2 );
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Add New Controlled Name', 'Add New Controlled Name', 'manage_options', 'Sub-Menu-Add-New-Controlled-Name', 'Troped_Add_New_Controlled_Name', 3 );
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Edit Controlled Names', 'Edit Controlled Names', 'manage_options', 'Sub-Menu-Edit-Controlled-Names', 'Troped_Edit_Controlled_Names', 4 );
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Edit Option Lists', 'Edit Option Lists', 'manage_options', 'Sub-Menu-Edit-Option-Lists', 'Troped_Edit_Option_Lists', 5 );
	add_submenu_page( 'Top-Menu-Troped-Resources', 'Add/Edit Classifications', 'Add/Edit Classifications', 'manage_options', 'Sub-Menu-AddEdit-Classifications', 'Troped_AddEdit_Classifications', 6 );
}

function Troped_Resources(){
	Troped_Admin_Redirect("index.php");
}

function Troped_Add_New_Resource(){
	Troped_Admin_Redirect("SPT--EditResource.php?ID=NEW");
}

function Troped_Edit_Resources(){
	Troped_Admin_Redirect("SPT--Advanced.php?Editing=1");
}

function Troped_Add_New_Controlled_Name(){
	Troped_Admin_Redirect("MetadataTool/SPT--AddControlledName.php");
}

function Troped_Edit_Controlled_Names(){
	Troped_Admin_Redirect("MetadataTool/SPT--EditControlledName.php?FieldId=0");
}

function Troped_Edit_Option_Lists(){
	Troped_Admin_Redirect("MetadataTool/SPT--EditControlledNameList.php?FieldId=1");
}

function Troped_AddEdit_Classifications(){
	Troped_Admin_Redirect("SPT--BrowseResources.php?Editing=1");
}
*/